@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetDefaultCniNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultCniNetworkName The name of the default CNI network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDefaultCniNetworkPlainArgs(
    public val defaultCniNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetDefaultCniNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetDefaultCniNetworkPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetDefaultCniNetworkPlainArgs.builder()
            .defaultCniNetworkName(defaultCniNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDefaultCniNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetDefaultCniNetworkPlainArgsBuilder internal constructor() {
    private var defaultCniNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the default CNI network.
     */
    @JvmName("mhtaybmtdwjsnuys")
    public suspend fun defaultCniNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.defaultCniNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmvdmmfkcutmdgym")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDefaultCniNetworkPlainArgs = GetDefaultCniNetworkPlainArgs(
        defaultCniNetworkName = defaultCniNetworkName ?: throw
            PulumiNullFieldException("defaultCniNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
