@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetHybridAksClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hybridAksClusterName The name of the Hybrid AKS cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetHybridAksClusterPlainArgs(
    public val hybridAksClusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetHybridAksClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetHybridAksClusterPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetHybridAksClusterPlainArgs.builder()
            .hybridAksClusterName(hybridAksClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridAksClusterPlainArgs].
 */
@PulumiTagMarker
public class GetHybridAksClusterPlainArgsBuilder internal constructor() {
    private var hybridAksClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Hybrid AKS cluster.
     */
    @JvmName("prxfueyxaiymknbo")
    public suspend fun hybridAksClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hybridAksClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("knwqlfnrvtxgeoyk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHybridAksClusterPlainArgs = GetHybridAksClusterPlainArgs(
        hybridAksClusterName = hybridAksClusterName ?: throw
            PulumiNullFieldException("hybridAksClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
