@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property azureUserName The user name that will be used for access.
 * @property description The free-form description for this user.
 * @property sshPublicKey The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
 */
public data class KeySetUserArgs(
    public val azureUserName: Output<String>,
    public val description: Output<String>? = null,
    public val sshPublicKey: Output<SshPublicKeyArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs =
        com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs.builder()
            .azureUserName(azureUserName.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .sshPublicKey(sshPublicKey.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeySetUserArgs].
 */
@PulumiTagMarker
public class KeySetUserArgsBuilder internal constructor() {
    private var azureUserName: Output<String>? = null

    private var description: Output<String>? = null

    private var sshPublicKey: Output<SshPublicKeyArgs>? = null

    /**
     * @param value The user name that will be used for access.
     */
    @JvmName("ehhoclmttndqqwhg")
    public suspend fun azureUserName(`value`: Output<String>) {
        this.azureUserName = value
    }

    /**
     * @param value The free-form description for this user.
     */
    @JvmName("bgblmulttolcfhqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("vslkhxfdtabrifqx")
    public suspend fun sshPublicKey(`value`: Output<SshPublicKeyArgs>) {
        this.sshPublicKey = value
    }

    /**
     * @param value The user name that will be used for access.
     */
    @JvmName("jxdvawytdubegdfc")
    public suspend fun azureUserName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureUserName = mapped
    }

    /**
     * @param value The free-form description for this user.
     */
    @JvmName("yqsybepapwijkyti")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("odnrciebxqxoudfo")
    public suspend fun sshPublicKey(`value`: SshPublicKeyArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicKey = mapped
    }

    /**
     * @param argument The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("pficyofcneggnbtg")
    public suspend fun sshPublicKey(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = SshPublicKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sshPublicKey = mapped
    }

    internal fun build(): KeySetUserArgs = KeySetUserArgs(
        azureUserName = azureUserName ?: throw PulumiNullFieldException("azureUserName"),
        description = description,
        sshPublicKey = sshPublicKey ?: throw PulumiNullFieldException("sshPublicKey"),
    )
}
