@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.L3NetworkAttachmentConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.KubernetesPluginType
import com.pulumi.azurenative.networkcloud.kotlin.enums.L3NetworkConfigurationIpamEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipamEnabled The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
 * @property networkId The resource ID of the network that is being configured for attachment.
 * @property pluginType The indicator of how this network will be utilized by the Kubernetes cluster.
 */
public data class L3NetworkAttachmentConfigurationArgs(
    public val ipamEnabled: Output<Either<String, L3NetworkConfigurationIpamEnabled>>? = null,
    public val networkId: Output<String>,
    public val pluginType: Output<Either<String, KubernetesPluginType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.L3NetworkAttachmentConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.L3NetworkAttachmentConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.L3NetworkAttachmentConfigurationArgs.builder()
            .ipamEnabled(
                ipamEnabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkId(networkId.applyValue({ args0 -> args0 }))
            .pluginType(
                pluginType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [L3NetworkAttachmentConfigurationArgs].
 */
@PulumiTagMarker
public class L3NetworkAttachmentConfigurationArgsBuilder internal constructor() {
    private var ipamEnabled: Output<Either<String, L3NetworkConfigurationIpamEnabled>>? = null

    private var networkId: Output<String>? = null

    private var pluginType: Output<Either<String, KubernetesPluginType>>? = null

    /**
     * @param value The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
     */
    @JvmName("yfufiklgnbbxkirs")
    public suspend
    fun ipamEnabled(`value`: Output<Either<String, L3NetworkConfigurationIpamEnabled>>) {
        this.ipamEnabled = value
    }

    /**
     * @param value The resource ID of the network that is being configured for attachment.
     */
    @JvmName("yvlxigiadnyldosr")
    public suspend fun networkId(`value`: Output<String>) {
        this.networkId = value
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("nyjmaqrxvcurgaug")
    public suspend fun pluginType(`value`: Output<Either<String, KubernetesPluginType>>) {
        this.pluginType = value
    }

    /**
     * @param value The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
     */
    @JvmName("ivdswavhieqmwirx")
    public suspend fun ipamEnabled(`value`: Either<String, L3NetworkConfigurationIpamEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamEnabled = mapped
    }

    /**
     * @param value The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
     */
    @JvmName("rjrfdiddpumehxre")
    public fun ipamEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, L3NetworkConfigurationIpamEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipamEnabled = mapped
    }

    /**
     * @param value The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
     */
    @JvmName("kjgtqnissblwauio")
    public fun ipamEnabled(`value`: L3NetworkConfigurationIpamEnabled) {
        val toBeMapped = Either.ofRight<String, L3NetworkConfigurationIpamEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipamEnabled = mapped
    }

    /**
     * @param value The resource ID of the network that is being configured for attachment.
     */
    @JvmName("xumganpkyntsgdxj")
    public suspend fun networkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkId = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("gmagwgpgnpbsddeu")
    public suspend fun pluginType(`value`: Either<String, KubernetesPluginType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("sxsgfktjqendersj")
    public fun pluginType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KubernetesPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("ftqpaktowwgntxcl")
    public fun pluginType(`value`: KubernetesPluginType) {
        val toBeMapped = Either.ofRight<String, KubernetesPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    internal fun build(): L3NetworkAttachmentConfigurationArgs = L3NetworkAttachmentConfigurationArgs(
        ipamEnabled = ipamEnabled,
        networkId = networkId ?: throw PulumiNullFieldException("networkId"),
        pluginType = pluginType,
    )
}
