@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.NetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attachedNetworkConfiguration The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
 * @property bgpServiceLoadBalancerConfiguration The configuration of the BGP service load balancer for this Kubernetes cluster.
 * @property cloudServicesNetworkId The resource ID of the associated Cloud Services network.
 * @property cniNetworkId The resource ID of the Layer 3 network that is used for creation of the Container Networking Interface network.
 * @property dnsServiceIp The IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in service CIDR.
 * @property podCidrs The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidrs The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 */
public data class NetworkConfigurationArgs(
    public val attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null,
    public val bgpServiceLoadBalancerConfiguration: Output<BgpServiceLoadBalancerConfigurationArgs>? =
        null,
    public val cloudServicesNetworkId: Output<String>,
    public val cniNetworkId: Output<String>,
    public val dnsServiceIp: Output<String>? = null,
    public val podCidrs: Output<List<String>>? = null,
    public val serviceCidrs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.NetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.NetworkConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.NetworkConfigurationArgs.builder()
            .attachedNetworkConfiguration(
                attachedNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .bgpServiceLoadBalancerConfiguration(
                bgpServiceLoadBalancerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .cloudServicesNetworkId(cloudServicesNetworkId.applyValue({ args0 -> args0 }))
            .cniNetworkId(cniNetworkId.applyValue({ args0 -> args0 }))
            .dnsServiceIp(dnsServiceIp?.applyValue({ args0 -> args0 }))
            .podCidrs(podCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceCidrs(serviceCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkConfigurationArgsBuilder internal constructor() {
    private var attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null

    private var bgpServiceLoadBalancerConfiguration: Output<BgpServiceLoadBalancerConfigurationArgs>? =
        null

    private var cloudServicesNetworkId: Output<String>? = null

    private var cniNetworkId: Output<String>? = null

    private var dnsServiceIp: Output<String>? = null

    private var podCidrs: Output<List<String>>? = null

    private var serviceCidrs: Output<List<String>>? = null

    /**
     * @param value The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("ylvckvvfibbghajb")
    public suspend
    fun attachedNetworkConfiguration(`value`: Output<AttachedNetworkConfigurationArgs>) {
        this.attachedNetworkConfiguration = value
    }

    /**
     * @param value The configuration of the BGP service load balancer for this Kubernetes cluster.
     */
    @JvmName("purvldwxxspbjhcx")
    public suspend
    fun bgpServiceLoadBalancerConfiguration(`value`: Output<BgpServiceLoadBalancerConfigurationArgs>) {
        this.bgpServiceLoadBalancerConfiguration = value
    }

    /**
     * @param value The resource ID of the associated Cloud Services network.
     */
    @JvmName("ilwcfgsqbjdxtnaq")
    public suspend fun cloudServicesNetworkId(`value`: Output<String>) {
        this.cloudServicesNetworkId = value
    }

    /**
     * @param value The resource ID of the Layer 3 network that is used for creation of the Container Networking Interface network.
     */
    @JvmName("ctgjlhsehdwacymv")
    public suspend fun cniNetworkId(`value`: Output<String>) {
        this.cniNetworkId = value
    }

    /**
     * @param value The IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in service CIDR.
     */
    @JvmName("iptscpppvgrcsmph")
    public suspend fun dnsServiceIp(`value`: Output<String>) {
        this.dnsServiceIp = value
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("ovkcrvcdpssvgich")
    public suspend fun podCidrs(`value`: Output<List<String>>) {
        this.podCidrs = value
    }

    @JvmName("sngiirrgvtythimm")
    public suspend fun podCidrs(vararg values: Output<String>) {
        this.podCidrs = Output.all(values.asList())
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("ghsakkvnfofrpown")
    public suspend fun podCidrs(values: List<Output<String>>) {
        this.podCidrs = Output.all(values)
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("yfjsrahplcxsxqhp")
    public suspend fun serviceCidrs(`value`: Output<List<String>>) {
        this.serviceCidrs = value
    }

    @JvmName("xeqcebfsxmjnmpnr")
    public suspend fun serviceCidrs(vararg values: Output<String>) {
        this.serviceCidrs = Output.all(values.asList())
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("messqphjylsgpmbd")
    public suspend fun serviceCidrs(values: List<Output<String>>) {
        this.serviceCidrs = Output.all(values)
    }

    /**
     * @param value The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("ccullnrfelsiidob")
    public suspend fun attachedNetworkConfiguration(`value`: AttachedNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param argument The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("fkywfwsokrogvyok")
    public suspend
    fun attachedNetworkConfiguration(argument: suspend AttachedNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AttachedNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param value The configuration of the BGP service load balancer for this Kubernetes cluster.
     */
    @JvmName("rxgjvhqpninldqig")
    public suspend
    fun bgpServiceLoadBalancerConfiguration(`value`: BgpServiceLoadBalancerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpServiceLoadBalancerConfiguration = mapped
    }

    /**
     * @param argument The configuration of the BGP service load balancer for this Kubernetes cluster.
     */
    @JvmName("ethmemrdwvnujecm")
    public suspend
    fun bgpServiceLoadBalancerConfiguration(argument: suspend BgpServiceLoadBalancerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BgpServiceLoadBalancerConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.bgpServiceLoadBalancerConfiguration = mapped
    }

    /**
     * @param value The resource ID of the associated Cloud Services network.
     */
    @JvmName("ffokluopndsawnal")
    public suspend fun cloudServicesNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudServicesNetworkId = mapped
    }

    /**
     * @param value The resource ID of the Layer 3 network that is used for creation of the Container Networking Interface network.
     */
    @JvmName("tkngersohyujgjcf")
    public suspend fun cniNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cniNetworkId = mapped
    }

    /**
     * @param value The IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in service CIDR.
     */
    @JvmName("bnnylkqojeypjmkt")
    public suspend fun dnsServiceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceIp = mapped
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("mypsbccmysuemfor")
    public suspend fun podCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("xednxlburrnhprad")
    public suspend fun podCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("lipeakhkmwmyccvk")
    public suspend fun serviceCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("jkrycqawgsgkuadq")
    public suspend fun serviceCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    internal fun build(): NetworkConfigurationArgs = NetworkConfigurationArgs(
        attachedNetworkConfiguration = attachedNetworkConfiguration,
        bgpServiceLoadBalancerConfiguration = bgpServiceLoadBalancerConfiguration,
        cloudServicesNetworkId = cloudServicesNetworkId ?: throw
            PulumiNullFieldException("cloudServicesNetworkId"),
        cniNetworkId = cniNetworkId ?: throw PulumiNullFieldException("cniNetworkId"),
        dnsServiceIp = dnsServiceIp,
        podCidrs = podCidrs,
        serviceCidrs = serviceCidrs,
    )
}
