@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.RackDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone The zone name used for this rack when created. Availability zones are used for workload placement.
 * @property bareMetalMachineConfigurationData The unordered list of bare metal machine configuration.
 * @property networkRackId The resource ID of the network rack that matches this rack definition.
 * @property rackLocation The free-form description of the rack's location.
 * @property rackSerialNumber The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
 * @property rackSkuId The resource ID of the sku for the rack being added.
 * @property storageApplianceConfigurationData The list of storage appliance configuration data for this rack.
 */
public data class RackDefinitionArgs(
    public val availabilityZone: Output<String>? = null,
    public val bareMetalMachineConfigurationData: Output<List<BareMetalMachineConfigurationDataArgs>>? =
        null,
    public val networkRackId: Output<String>,
    public val rackLocation: Output<String>? = null,
    public val rackSerialNumber: Output<String>,
    public val rackSkuId: Output<String>,
    public val storageApplianceConfigurationData: Output<List<StorageApplianceConfigurationDataArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.RackDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.RackDefinitionArgs =
        com.pulumi.azurenative.networkcloud.inputs.RackDefinitionArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .bareMetalMachineConfigurationData(
                bareMetalMachineConfigurationData?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .networkRackId(networkRackId.applyValue({ args0 -> args0 }))
            .rackLocation(rackLocation?.applyValue({ args0 -> args0 }))
            .rackSerialNumber(rackSerialNumber.applyValue({ args0 -> args0 }))
            .rackSkuId(rackSkuId.applyValue({ args0 -> args0 }))
            .storageApplianceConfigurationData(
                storageApplianceConfigurationData?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [RackDefinitionArgs].
 */
@PulumiTagMarker
public class RackDefinitionArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var bareMetalMachineConfigurationData:
        Output<List<BareMetalMachineConfigurationDataArgs>>? = null

    private var networkRackId: Output<String>? = null

    private var rackLocation: Output<String>? = null

    private var rackSerialNumber: Output<String>? = null

    private var rackSkuId: Output<String>? = null

    private var storageApplianceConfigurationData:
        Output<List<StorageApplianceConfigurationDataArgs>>? = null

    /**
     * @param value The zone name used for this rack when created. Availability zones are used for workload placement.
     */
    @JvmName("sbsrrardsbkjedjo")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The unordered list of bare metal machine configuration.
     */
    @JvmName("xrsamiiveelfxsyx")
    public suspend
    fun bareMetalMachineConfigurationData(`value`: Output<List<BareMetalMachineConfigurationDataArgs>>) {
        this.bareMetalMachineConfigurationData = value
    }

    @JvmName("kbdpefkjufbyvplb")
    public suspend fun bareMetalMachineConfigurationData(
        vararg
        values: Output<BareMetalMachineConfigurationDataArgs>,
    ) {
        this.bareMetalMachineConfigurationData = Output.all(values.asList())
    }

    /**
     * @param values The unordered list of bare metal machine configuration.
     */
    @JvmName("tujxwjvyclqsclsh")
    public suspend
    fun bareMetalMachineConfigurationData(values: List<Output<BareMetalMachineConfigurationDataArgs>>) {
        this.bareMetalMachineConfigurationData = Output.all(values)
    }

    /**
     * @param value The resource ID of the network rack that matches this rack definition.
     */
    @JvmName("hogjrdiqcjrcqjod")
    public suspend fun networkRackId(`value`: Output<String>) {
        this.networkRackId = value
    }

    /**
     * @param value The free-form description of the rack's location.
     */
    @JvmName("vxfyasgkxkvlqkqe")
    public suspend fun rackLocation(`value`: Output<String>) {
        this.rackLocation = value
    }

    /**
     * @param value The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
     */
    @JvmName("pqaerhxjxcpkkorc")
    public suspend fun rackSerialNumber(`value`: Output<String>) {
        this.rackSerialNumber = value
    }

    /**
     * @param value The resource ID of the sku for the rack being added.
     */
    @JvmName("ywwyxfsxmplqnlgy")
    public suspend fun rackSkuId(`value`: Output<String>) {
        this.rackSkuId = value
    }

    /**
     * @param value The list of storage appliance configuration data for this rack.
     */
    @JvmName("pudxubuvfibqbnxb")
    public suspend
    fun storageApplianceConfigurationData(`value`: Output<List<StorageApplianceConfigurationDataArgs>>) {
        this.storageApplianceConfigurationData = value
    }

    @JvmName("rqrhtsjcmhdkqkff")
    public suspend fun storageApplianceConfigurationData(
        vararg
        values: Output<StorageApplianceConfigurationDataArgs>,
    ) {
        this.storageApplianceConfigurationData = Output.all(values.asList())
    }

    /**
     * @param values The list of storage appliance configuration data for this rack.
     */
    @JvmName("rvyukyjscahajcan")
    public suspend
    fun storageApplianceConfigurationData(values: List<Output<StorageApplianceConfigurationDataArgs>>) {
        this.storageApplianceConfigurationData = Output.all(values)
    }

    /**
     * @param value The zone name used for this rack when created. Availability zones are used for workload placement.
     */
    @JvmName("ruxwguitmigcitlv")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The unordered list of bare metal machine configuration.
     */
    @JvmName("dqipesvpqgngvbrw")
    public suspend
    fun bareMetalMachineConfigurationData(`value`: List<BareMetalMachineConfigurationDataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetalMachineConfigurationData = mapped
    }

    /**
     * @param argument The unordered list of bare metal machine configuration.
     */
    @JvmName("aypuclmrbgpodtja")
    public suspend
    fun bareMetalMachineConfigurationData(argument: List<suspend BareMetalMachineConfigurationDataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BareMetalMachineConfigurationDataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bareMetalMachineConfigurationData = mapped
    }

    /**
     * @param argument The unordered list of bare metal machine configuration.
     */
    @JvmName("nmqkxfupbgeybayt")
    public suspend fun bareMetalMachineConfigurationData(
        vararg
        argument: suspend BareMetalMachineConfigurationDataArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BareMetalMachineConfigurationDataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bareMetalMachineConfigurationData = mapped
    }

    /**
     * @param argument The unordered list of bare metal machine configuration.
     */
    @JvmName("pavwkmdebpwpkhab")
    public suspend
    fun bareMetalMachineConfigurationData(argument: suspend BareMetalMachineConfigurationDataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BareMetalMachineConfigurationDataArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bareMetalMachineConfigurationData = mapped
    }

    /**
     * @param values The unordered list of bare metal machine configuration.
     */
    @JvmName("bwgggcekwxybgwah")
    public suspend fun bareMetalMachineConfigurationData(
        vararg
        values: BareMetalMachineConfigurationDataArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bareMetalMachineConfigurationData = mapped
    }

    /**
     * @param value The resource ID of the network rack that matches this rack definition.
     */
    @JvmName("lumxaaddrqatkhtf")
    public suspend fun networkRackId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkRackId = mapped
    }

    /**
     * @param value The free-form description of the rack's location.
     */
    @JvmName("jtunlhsxnlwqensl")
    public suspend fun rackLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackLocation = mapped
    }

    /**
     * @param value The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
     */
    @JvmName("vefbbkvmjtqscoxv")
    public suspend fun rackSerialNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rackSerialNumber = mapped
    }

    /**
     * @param value The resource ID of the sku for the rack being added.
     */
    @JvmName("reoqwcmrlpuphpml")
    public suspend fun rackSkuId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rackSkuId = mapped
    }

    /**
     * @param value The list of storage appliance configuration data for this rack.
     */
    @JvmName("vxjdujksqqdlnssa")
    public suspend
    fun storageApplianceConfigurationData(`value`: List<StorageApplianceConfigurationDataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageApplianceConfigurationData = mapped
    }

    /**
     * @param argument The list of storage appliance configuration data for this rack.
     */
    @JvmName("hafxfpajlxvxofje")
    public suspend
    fun storageApplianceConfigurationData(argument: List<suspend StorageApplianceConfigurationDataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageApplianceConfigurationDataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageApplianceConfigurationData = mapped
    }

    /**
     * @param argument The list of storage appliance configuration data for this rack.
     */
    @JvmName("cedxtvfkcldifwwv")
    public suspend fun storageApplianceConfigurationData(
        vararg
        argument: suspend StorageApplianceConfigurationDataArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageApplianceConfigurationDataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageApplianceConfigurationData = mapped
    }

    /**
     * @param argument The list of storage appliance configuration data for this rack.
     */
    @JvmName("oqqwksnvsvbbvhtm")
    public suspend
    fun storageApplianceConfigurationData(argument: suspend StorageApplianceConfigurationDataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StorageApplianceConfigurationDataArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageApplianceConfigurationData = mapped
    }

    /**
     * @param values The list of storage appliance configuration data for this rack.
     */
    @JvmName("bqakuyksggcdigtp")
    public suspend fun storageApplianceConfigurationData(
        vararg
        values: StorageApplianceConfigurationDataArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageApplianceConfigurationData = mapped
    }

    internal fun build(): RackDefinitionArgs = RackDefinitionArgs(
        availabilityZone = availabilityZone,
        bareMetalMachineConfigurationData = bareMetalMachineConfigurationData,
        networkRackId = networkRackId ?: throw PulumiNullFieldException("networkRackId"),
        rackLocation = rackLocation,
        rackSerialNumber = rackSerialNumber ?: throw PulumiNullFieldException("rackSerialNumber"),
        rackSkuId = rackSkuId ?: throw PulumiNullFieldException("rackSkuId"),
        storageApplianceConfigurationData = storageApplianceConfigurationData,
    )
}
