@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.VirtualMachinePlacementHintArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachinePlacementHintPodAffinityScope
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachinePlacementHintType
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineSchedulingExecution
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hintType The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
 * @property resourceId The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
 * @property schedulingExecution The indicator of whether the hint is a hard or soft requirement during scheduling.
 * @property scope The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
 */
public data class VirtualMachinePlacementHintArgs(
    public val hintType: Output<Either<String, VirtualMachinePlacementHintType>>,
    public val resourceId: Output<String>,
    public val schedulingExecution: Output<Either<String, VirtualMachineSchedulingExecution>>,
    public val scope: Output<Either<String, VirtualMachinePlacementHintPodAffinityScope>>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.VirtualMachinePlacementHintArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.VirtualMachinePlacementHintArgs =
        com.pulumi.azurenative.networkcloud.inputs.VirtualMachinePlacementHintArgs.builder()
            .hintType(
                hintType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .schedulingExecution(
                schedulingExecution.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scope(
                scope.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachinePlacementHintArgs].
 */
@PulumiTagMarker
public class VirtualMachinePlacementHintArgsBuilder internal constructor() {
    private var hintType: Output<Either<String, VirtualMachinePlacementHintType>>? = null

    private var resourceId: Output<String>? = null

    private var schedulingExecution: Output<Either<String, VirtualMachineSchedulingExecution>>? = null

    private var scope: Output<Either<String, VirtualMachinePlacementHintPodAffinityScope>>? = null

    /**
     * @param value The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
     */
    @JvmName("ocwjacyroqocjisb")
    public suspend fun hintType(`value`: Output<Either<String, VirtualMachinePlacementHintType>>) {
        this.hintType = value
    }

    /**
     * @param value The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
     */
    @JvmName("qmkhpyqkagillwvd")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The indicator of whether the hint is a hard or soft requirement during scheduling.
     */
    @JvmName("gydrsgxcgofowkfq")
    public suspend
    fun schedulingExecution(`value`: Output<Either<String, VirtualMachineSchedulingExecution>>) {
        this.schedulingExecution = value
    }

    /**
     * @param value The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
     */
    @JvmName("crpjciucqespmtln")
    public suspend
    fun scope(`value`: Output<Either<String, VirtualMachinePlacementHintPodAffinityScope>>) {
        this.scope = value
    }

    /**
     * @param value The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
     */
    @JvmName("feamlawvqkklbrnh")
    public suspend fun hintType(`value`: Either<String, VirtualMachinePlacementHintType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hintType = mapped
    }

    /**
     * @param value The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
     */
    @JvmName("jaxhvgetpjoxguvq")
    public fun hintType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachinePlacementHintType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hintType = mapped
    }

    /**
     * @param value The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
     */
    @JvmName("rvycbtkclefxoujn")
    public fun hintType(`value`: VirtualMachinePlacementHintType) {
        val toBeMapped = Either.ofRight<String, VirtualMachinePlacementHintType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hintType = mapped
    }

    /**
     * @param value The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
     */
    @JvmName("liebekkniggpcotd")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The indicator of whether the hint is a hard or soft requirement during scheduling.
     */
    @JvmName("fajsiinhktnnsjqg")
    public suspend
    fun schedulingExecution(`value`: Either<String, VirtualMachineSchedulingExecution>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulingExecution = mapped
    }

    /**
     * @param value The indicator of whether the hint is a hard or soft requirement during scheduling.
     */
    @JvmName("ryhpsyahusixurlb")
    public fun schedulingExecution(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineSchedulingExecution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulingExecution = mapped
    }

    /**
     * @param value The indicator of whether the hint is a hard or soft requirement during scheduling.
     */
    @JvmName("fsduslplquwcgdlo")
    public fun schedulingExecution(`value`: VirtualMachineSchedulingExecution) {
        val toBeMapped = Either.ofRight<String, VirtualMachineSchedulingExecution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulingExecution = mapped
    }

    /**
     * @param value The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
     */
    @JvmName("pccsuatqrvwgiqrr")
    public suspend fun scope(`value`: Either<String, VirtualMachinePlacementHintPodAffinityScope>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
     */
    @JvmName("mrsbwptickcvnxlu")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachinePlacementHintPodAffinityScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
     */
    @JvmName("rdaqlxfpkwxjwhvq")
    public fun scope(`value`: VirtualMachinePlacementHintPodAffinityScope) {
        val toBeMapped = Either.ofRight<String, VirtualMachinePlacementHintPodAffinityScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): VirtualMachinePlacementHintArgs = VirtualMachinePlacementHintArgs(
        hintType = hintType ?: throw PulumiNullFieldException("hintType"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        schedulingExecution = schedulingExecution ?: throw PulumiNullFieldException("schedulingExecution"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
