@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property asNumber The ASN (Autonomous System Number) of the BGP peer.
 * @property peerIp The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
 */
public data class BgpPeerResponse(
    public val asNumber: Double,
    public val peerIp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.BgpPeerResponse):
            BgpPeerResponse = BgpPeerResponse(
            asNumber = javaType.asNumber(),
            peerIp = javaType.peerIp(),
        )
    }
}
