@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bgpPeers The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
 * @property communityAdvertisements The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
 * communities that should be associated with that prefix when it is announced.
 * @property serviceExternalPrefixes The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
 * @property serviceLoadBalancerPrefixes The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
 * are within one of these blocks.
 */
public data class CniBgpConfigurationResponse(
    public val bgpPeers: List<BgpPeerResponse>? = null,
    public val communityAdvertisements: List<CommunityAdvertisementResponse>? = null,
    public val serviceExternalPrefixes: List<String>? = null,
    public val serviceLoadBalancerPrefixes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.CniBgpConfigurationResponse):
            CniBgpConfigurationResponse = CniBgpConfigurationResponse(
            bgpPeers = javaType.bgpPeers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpPeerResponse.Companion.toKotlin(args0)
                })
            }),
            communityAdvertisements = javaType.communityAdvertisements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.CommunityAdvertisementResponse.Companion.toKotlin(args0)
                })
            }),
            serviceExternalPrefixes = javaType.serviceExternalPrefixes().map({ args0 -> args0 }),
            serviceLoadBalancerPrefixes = javaType.serviceLoadBalancerPrefixes().map({ args0 -> args0 }),
        )
    }
}
