@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property communities The list of community strings to announce with this prefix.
 * @property subnetPrefix The subnet in CIDR format for which properties should be advertised.
 */
public data class CommunityAdvertisementResponse(
    public val communities: List<String>,
    public val subnetPrefix: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.CommunityAdvertisementResponse):
            CommunityAdvertisementResponse = CommunityAdvertisementResponse(
            communities = javaType.communities().map({ args0 -> args0 }),
            subnetPrefix = javaType.subnetPrefix(),
        )
    }
}
