@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The domain name of the dependency.
 * @property port The port of this endpoint.
 */
public data class EndpointDependencyResponse(
    public val domainName: String,
    public val port: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.EndpointDependencyResponse):
            EndpointDependencyResponse = EndpointDependencyResponse(
            domainName = javaType.domainName(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
