@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property analyticsWorkspaceId The resource ID of the Log Analytics workspace that is used for the logs collection.
 * @property availabilityZones Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
 * @property clusterVersions The list of the cluster versions the manager supports. It is used as input in clusterVersion property of a cluster resource.
 * @property detailedStatus The detailed status that provides additional information about the cluster manager.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property fabricControllerId The resource ID of the fabric controller that has one to one mapping with the cluster manager.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property managerExtendedLocation The extended location (custom location) that represents the cluster manager's control plane location. This extended location is used when creating cluster and rack manifest resources.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the cluster manager.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmSize Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The size of the Azure virtual machines to use for hosting the cluster manager resource.
 */
public data class GetClusterManagerResult(
    public val analyticsWorkspaceId: String? = null,
    public val availabilityZones: List<String>? = null,
    public val clusterVersions: List<ClusterAvailableVersionResponse>,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val fabricControllerId: String,
    public val id: String,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedResourceGroupConfigurationResponse? = null,
    public val managerExtendedLocation: ExtendedLocationResponse,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetClusterManagerResult):
            GetClusterManagerResult = GetClusterManagerResult(
            analyticsWorkspaceId = javaType.analyticsWorkspaceId().map({ args0 -> args0 }).orElse(null),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            clusterVersions = javaType.clusterVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableVersionResponse.Companion.toKotlin(args0)
                })
            }),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            fabricControllerId = javaType.fabricControllerId(),
            id = javaType.id(),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managerExtendedLocation = javaType.managerExtendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
