@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property clusterId The resource ID of the Network Cloud cluster this default CNI network is associated with.
 * @property cniAsNumber The autonomous system number that the fabric expects to peer with, derived from the associated L3 isolation domain.
 * @property cniBgpConfiguration The Calico BGP configuration.
 * @property detailedStatus The more detailed status of the default CNI network.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property fabricBgpPeers The L3 isolation fabric BGP peering connectivity information necessary for BGP peering the Hybrid AKS Cluster with the switch fabric.
 * @property hybridAksClustersAssociatedIds The list of Hybrid AKS cluster resource ID(s) that are associated with this default CNI network.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property interfaceName The name of the interface that will be present in the virtual machine to represent this network.
 * @property ipAllocationType The type of the IP address allocation.
 * @property ipv4ConnectedPrefix The IPV4 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
 * is IPV4 or DualStack.
 * @property ipv6ConnectedPrefix The IPV6 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
 * is IPV6 or DualStack.
 * @property l3IsolationDomainId The resource ID of the Network Fabric l3IsolationDomain.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the default CNI network.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vlan The VLAN from the l3IsolationDomain that is used for this network.
 */
public data class GetDefaultCniNetworkResult(
    public val clusterId: String,
    public val cniAsNumber: Double,
    public val cniBgpConfiguration: CniBgpConfigurationResponse? = null,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val fabricBgpPeers: List<BgpPeerResponse>,
    public val hybridAksClustersAssociatedIds: List<String>,
    public val id: String,
    public val interfaceName: String,
    public val ipAllocationType: String? = null,
    public val ipv4ConnectedPrefix: String? = null,
    public val ipv6ConnectedPrefix: String? = null,
    public val l3IsolationDomainId: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vlan: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetDefaultCniNetworkResult):
            GetDefaultCniNetworkResult = GetDefaultCniNetworkResult(
            clusterId = javaType.clusterId(),
            cniAsNumber = javaType.cniAsNumber(),
            cniBgpConfiguration = javaType.cniBgpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.CniBgpConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            fabricBgpPeers = javaType.fabricBgpPeers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpPeerResponse.Companion.toKotlin(args0)
                })
            }),
            hybridAksClustersAssociatedIds = javaType.hybridAksClustersAssociatedIds().map({ args0 -> args0 }),
            id = javaType.id(),
            interfaceName = javaType.interfaceName(),
            ipAllocationType = javaType.ipAllocationType().map({ args0 -> args0 }).orElse(null),
            ipv4ConnectedPrefix = javaType.ipv4ConnectedPrefix().map({ args0 -> args0 }).orElse(null),
            ipv6ConnectedPrefix = javaType.ipv6ConnectedPrefix().map({ args0 -> args0 }).orElse(null),
            l3IsolationDomainId = javaType.l3IsolationDomainId(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vlan = javaType.vlan(),
        )
    }
}
