@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The details are specific to the Network Cloud use of the Hybrid AKS cluster.
 * @property associatedNetworkIds The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
 * @property cloudServicesNetworkId The resource ID of the associated cloud services network.
 * @property clusterId The resource ID of the Network Cloud cluster hosting the Hybrid AKS cluster.
 * @property controlPlaneCount The number of control plane node VMs.
 * @property controlPlaneNodes The list of node configurations detailing associated VMs that are part of the control plane nodes of this Hybrid AKS cluster.
 * @property defaultCniNetworkId The resource ID of the associated default CNI network.
 * @property detailedStatus The more detailed status of this Hybrid AKS cluster.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksProvisionedClusterId The resource ID of the Hybrid AKS cluster that this additional information is for.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the Hybrid AKS cluster resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property volumes The resource IDs of volumes that are attached to the Hybrid AKS cluster.
 * @property workerCount The number of worker node VMs.
 * @property workerNodes The list of node configurations detailing associated VMs that are part of the worker nodes of this Hybrid AKS cluster.
 */
public data class GetHybridAksClusterResult(
    public val associatedNetworkIds: List<String>,
    public val cloudServicesNetworkId: String,
    public val clusterId: String,
    public val controlPlaneCount: Double,
    public val controlPlaneNodes: List<NodeConfigurationResponse>,
    public val defaultCniNetworkId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val hybridAksProvisionedClusterId: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val volumes: List<String>,
    public val workerCount: Double,
    public val workerNodes: List<NodeConfigurationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetHybridAksClusterResult):
            GetHybridAksClusterResult = GetHybridAksClusterResult(
            associatedNetworkIds = javaType.associatedNetworkIds().map({ args0 -> args0 }),
            cloudServicesNetworkId = javaType.cloudServicesNetworkId(),
            clusterId = javaType.clusterId(),
            controlPlaneCount = javaType.controlPlaneCount(),
            controlPlaneNodes = javaType.controlPlaneNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            defaultCniNetworkId = javaType.defaultCniNetworkId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hybridAksProvisionedClusterId = javaType.hybridAksProvisionedClusterId(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            volumes = javaType.volumes().map({ args0 -> args0 }),
            workerCount = javaType.workerCount(),
            workerNodes = javaType.workerNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
