@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property administratorConfiguration The administrator credentials to be used for the nodes in this agent pool.
 * @property agentOptions The configurations that will be applied to each agent in this agent pool.
 * @property attachedNetworkConfiguration The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property labels The labels applied to the nodes in this agent pool.
 * @property mode The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
 * @property name The name that will be used for the agent pool resource representing this agent pool.
 * @property taints The taints applied to the nodes in this agent pool.
 * @property upgradeSettings The configuration of the agent pool.
 * @property vmSkuName The name of the VM SKU that determines the size of resources allocated for node VMs.
 */
public data class InitialAgentPoolConfigurationResponse(
    public val administratorConfiguration: AdministratorConfigurationResponse? = null,
    public val agentOptions: AgentOptionsResponse? = null,
    public val attachedNetworkConfiguration: AttachedNetworkConfigurationResponse? = null,
    public val availabilityZones: List<String>? = null,
    public val count: Double,
    public val labels: List<KubernetesLabelResponse>? = null,
    public val mode: String,
    public val name: String,
    public val taints: List<KubernetesLabelResponse>? = null,
    public val upgradeSettings: AgentPoolUpgradeSettingsResponse? = null,
    public val vmSkuName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.InitialAgentPoolConfigurationResponse):
            InitialAgentPoolConfigurationResponse = InitialAgentPoolConfigurationResponse(
            administratorConfiguration = javaType.administratorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentOptions = javaType.agentOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            attachedNetworkConfiguration = javaType.attachedNetworkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AttachedNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            count = javaType.count(),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            mode = javaType.mode(),
            name = javaType.name(),
            taints = javaType.taints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            upgradeSettings = javaType.upgradeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentPoolUpgradeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmSkuName = javaType.vmSkuName(),
        )
    }
}
