@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addresses The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
 * @property autoAssign The indicator to determine if automatic allocation from the pool should occur.
 * @property name The name used to identify this IP address pool for association with a BGP advertisement.
 * @property onlyUseHostIps The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
 */
public data class IpAddressPoolResponse(
    public val addresses: List<String>,
    public val autoAssign: String? = null,
    public val name: String,
    public val onlyUseHostIps: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.IpAddressPoolResponse):
            IpAddressPoolResponse = IpAddressPoolResponse(
            addresses = javaType.addresses().map({ args0 -> args0 }),
            autoAssign = javaType.autoAssign().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onlyUseHostIps = javaType.onlyUseHostIps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
