@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property agentPoolId The resource ID of the agent pool that this node belongs to. This value is not represented on control plane nodes.
 * @property availabilityZone The availability zone this node is running within.
 * @property bareMetalMachineId The resource ID of the bare metal machine that hosts this node.
 * @property cpuCores The number of CPU cores configured for this node, derived from the VM SKU specified.
 * @property detailedStatus The detailed state of this node.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property diskSizeGB The size of the disk configured for this node.
 * @property image The machine image used to deploy this node.
 * @property kubernetesVersion The currently running version of Kubernetes and bundled features running on this node.
 * @property labels The list of labels on this node that have been assigned to the agent pool containing this node.
 * @property memorySizeGB The amount of memory configured for this node, derived from the vm SKU specified.
 * @property mode The mode of the agent pool containing this node. Not applicable for control plane nodes.
 * @property name The name of this node, as realized in the Kubernetes cluster.
 * @property networkAttachments The NetworkAttachments made to this node.
 * @property powerState The power state of this node.
 * @property role The role of this node in the cluster.
 * @property taints The list of taints that have been assigned to the agent pool containing this node.
 * @property vmSkuName The VM SKU name that was used to create this cluster node.
 */
public data class KubernetesClusterNodeResponse(
    public val agentPoolId: String,
    public val availabilityZone: String,
    public val bareMetalMachineId: String,
    public val cpuCores: Double,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val diskSizeGB: Double,
    public val image: String,
    public val kubernetesVersion: String,
    public val labels: List<KubernetesLabelResponse>,
    public val memorySizeGB: Double,
    public val mode: String,
    public val name: String,
    public val networkAttachments: List<NetworkAttachmentResponse>,
    public val powerState: String,
    public val role: String,
    public val taints: List<KubernetesLabelResponse>,
    public val vmSkuName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.KubernetesClusterNodeResponse):
            KubernetesClusterNodeResponse = KubernetesClusterNodeResponse(
            agentPoolId = javaType.agentPoolId(),
            availabilityZone = javaType.availabilityZone(),
            bareMetalMachineId = javaType.bareMetalMachineId(),
            cpuCores = javaType.cpuCores(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            diskSizeGB = javaType.diskSizeGB(),
            image = javaType.image(),
            kubernetesVersion = javaType.kubernetesVersion(),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            memorySizeGB = javaType.memorySizeGB(),
            mode = javaType.mode(),
            name = javaType.name(),
            networkAttachments = javaType.networkAttachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse.Companion.toKotlin(args0)
                })
            }),
            powerState = javaType.powerState(),
            role = javaType.role(),
            taints = javaType.taints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            vmSkuName = javaType.vmSkuName(),
        )
    }
}
