@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipamEnabled The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
 * @property networkId The resource ID of the network that is being configured for attachment.
 * @property pluginType The indicator of how this network will be utilized by the Kubernetes cluster.
 */
public data class L3NetworkAttachmentConfigurationResponse(
    public val ipamEnabled: String? = null,
    public val networkId: String,
    public val pluginType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.L3NetworkAttachmentConfigurationResponse):
            L3NetworkAttachmentConfigurationResponse = L3NetworkAttachmentConfigurationResponse(
            ipamEnabled = javaType.ipamEnabled().map({ args0 -> args0 }).orElse(null),
            networkId = javaType.networkId(),
            pluginType = javaType.pluginType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
