@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachedNetworkId The resource ID of the associated network attached to the virtual machine.
 * It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
 * @property defaultGateway The indicator of whether this is the default gateway.
 * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
 * @property ipAllocationMethod The IP allocation mechanism for the virtual machine.
 * Dynamic and Static are only valid for l3Network which may also specify Disabled.
 * Otherwise, Disabled is the only permitted value.
 * @property ipv4Address The IPv4 address of the virtual machine.
 * This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
 * If IPAllocationMethod is:
 * Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
 * Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
 * Disabled - this field will be empty.
 * @property ipv6Address The IPv6 address of the virtual machine.
 * This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
 * If IPAllocationMethod is:
 * Static - this field must contain an IPv6 address range from within the range specified in the attached network.
 * Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
 * Disabled - this field will be empty.
 * @property macAddress The MAC address of the interface for the virtual machine that corresponds to this network attachment.
 * @property networkAttachmentName The associated network's interface name.
 * If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
 * If the user doesn’t specify this value, the default interface name of the network resource will be used.
 * For a CloudServicesNetwork resource, this name will be ignored.
 */
public data class NetworkAttachmentResponse(
    public val attachedNetworkId: String,
    public val defaultGateway: String? = null,
    public val ipAllocationMethod: String,
    public val ipv4Address: String? = null,
    public val ipv6Address: String? = null,
    public val macAddress: String,
    public val networkAttachmentName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.NetworkAttachmentResponse):
            NetworkAttachmentResponse = NetworkAttachmentResponse(
            attachedNetworkId = javaType.attachedNetworkId(),
            defaultGateway = javaType.defaultGateway().map({ args0 -> args0 }).orElse(null),
            ipAllocationMethod = javaType.ipAllocationMethod(),
            ipv4Address = javaType.ipv4Address().map({ args0 -> args0 }).orElse(null),
            ipv6Address = javaType.ipv6Address().map({ args0 -> args0 }).orElse(null),
            macAddress = javaType.macAddress(),
            networkAttachmentName = javaType.networkAttachmentName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
