@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property agentPoolId The resource ID of the agent pool that contains the nodes in this configuration.
 * @property agentPoolName The name of the agent pool that contains the nodes in this configuration.
 * @property cpuCores The number of CPU cores in the virtual machine.
 * @property diskSizeGB The root disk size of the virtual machine in GB.
 * @property memorySizeGB The memory size of the virtual machine in GB.
 * @property nodePoolName Field deprecated, use agentPoolName instead. This field will be removed in a future version but will reflect the name of the agent pool that contains the nodes in this configuration.
 * @property nodes The list of nodes that utilize this configuration.
 * @property vmCount The number of virtual machines that use this configuration.
 * @property vmSize The name of the VM size supplied during the creation of the cluster.
 */
public data class NodeConfigurationResponse(
    public val agentPoolId: String,
    public val agentPoolName: String,
    public val cpuCores: Double,
    public val diskSizeGB: Double,
    public val memorySizeGB: Double,
    public val nodePoolName: String,
    public val nodes: List<NodeResponse>,
    public val vmCount: Double,
    public val vmSize: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.NodeConfigurationResponse):
            NodeConfigurationResponse = NodeConfigurationResponse(
            agentPoolId = javaType.agentPoolId(),
            agentPoolName = javaType.agentPoolName(),
            cpuCores = javaType.cpuCores(),
            diskSizeGB = javaType.diskSizeGB(),
            memorySizeGB = javaType.memorySizeGB(),
            nodePoolName = javaType.nodePoolName(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NodeResponse.Companion.toKotlin(args0)
                })
            }),
            vmCount = javaType.vmCount(),
            vmSize = javaType.vmSize(),
        )
    }
}
