@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bareMetalMachineId The resource ID of the bare metal machine that hosts this node.
 * @property imageId The machine image last used to deploy this node.
 * @property networkAttachments The list of network attachments to the virtual machine.
 * @property nodeName The name of this node, as realized in the Hybrid AKS cluster.
 * @property powerState The power state (On | Off) of the node.
 */
public data class NodeResponse(
    public val bareMetalMachineId: String,
    public val imageId: String,
    public val networkAttachments: List<NetworkAttachmentResponse>,
    public val nodeName: String,
    public val powerState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.NodeResponse):
            NodeResponse = NodeResponse(
            bareMetalMachineId = javaType.bareMetalMachineId(),
            imageId = javaType.imageId(),
            networkAttachments = javaType.networkAttachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse.Companion.toKotlin(args0)
                })
            }),
            nodeName = javaType.nodeName(),
            powerState = javaType.powerState(),
        )
    }
}
