@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The zone name used for this rack when created. Availability zones are used for workload placement.
 * @property bareMetalMachineConfigurationData The unordered list of bare metal machine configuration.
 * @property networkRackId The resource ID of the network rack that matches this rack definition.
 * @property rackLocation The free-form description of the rack's location.
 * @property rackSerialNumber The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
 * @property rackSkuId The resource ID of the sku for the rack being added.
 * @property storageApplianceConfigurationData The list of storage appliance configuration data for this rack.
 */
public data class RackDefinitionResponse(
    public val availabilityZone: String? = null,
    public val bareMetalMachineConfigurationData: List<BareMetalMachineConfigurationDataResponse>? =
        null,
    public val networkRackId: String,
    public val rackLocation: String? = null,
    public val rackSerialNumber: String,
    public val rackSkuId: String,
    public val storageApplianceConfigurationData: List<StorageApplianceConfigurationDataResponse>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.RackDefinitionResponse):
            RackDefinitionResponse = RackDefinitionResponse(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            bareMetalMachineConfigurationData = javaType.bareMetalMachineConfigurationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.BareMetalMachineConfigurationDataResponse.Companion.toKotlin(args0)
                })
            }),
            networkRackId = javaType.networkRackId(),
            rackLocation = javaType.rackLocation().map({ args0 -> args0 }).orElse(null),
            rackSerialNumber = javaType.rackSerialNumber(),
            rackSkuId = javaType.rackSkuId(),
            storageApplianceConfigurationData = javaType.storageApplianceConfigurationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.StorageApplianceConfigurationDataResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
