@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hintType The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
 * @property resourceId The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
 * @property schedulingExecution The indicator of whether the hint is a hard or soft requirement during scheduling.
 * @property scope The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
 */
public data class VirtualMachinePlacementHintResponse(
    public val hintType: String,
    public val resourceId: String,
    public val schedulingExecution: String,
    public val scope: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.VirtualMachinePlacementHintResponse):
            VirtualMachinePlacementHintResponse = VirtualMachinePlacementHintResponse(
            hintType = javaType.hintType(),
            resourceId = javaType.resourceId(),
            schedulingExecution = javaType.schedulingExecution(),
            scope = javaType.scope(),
        )
    }
}
