@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.kotlin.outputs.EmissionPoliciesPropertiesFormatResponse
import com.pulumi.azurenative.networkfunction.kotlin.outputs.IngestionPolicyPropertiesFormatResponse
import com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkfunction.kotlin.outputs.EmissionPoliciesPropertiesFormatResponse.Companion.toKotlin as emissionPoliciesPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.networkfunction.kotlin.outputs.IngestionPolicyPropertiesFormatResponse.Companion.toKotlin as ingestionPolicyPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin as trackedResourceResponseSystemDataToKotlin

/**
 * Builder for [CollectorPolicy].
 */
@PulumiTagMarker
public class CollectorPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CollectorPolicyArgs = CollectorPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CollectorPolicyArgsBuilder.() -> Unit) {
        val builder = CollectorPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CollectorPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.networkfunction.CollectorPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CollectorPolicy(builtJavaResource)
    }
}

/**
 * Collector policy resource.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-05-01.
 * Other available API versions: 2022-05-01.
 * ## Example Usage
 * ### Create a collection policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var collectorPolicy = new AzureNative.NetworkFunction.CollectorPolicy("collectorPolicy", new()
 *     {
 *         AzureTrafficCollectorName = "atc",
 *         CollectorPolicyName = "cp1",
 *         EmissionPolicies = new[]
 *         {
 *             new AzureNative.NetworkFunction.Inputs.EmissionPoliciesPropertiesFormatArgs
 *             {
 *                 EmissionDestinations = new[]
 *                 {
 *                     new AzureNative.NetworkFunction.Inputs.EmissionPolicyDestinationArgs
 *                     {
 *                         DestinationType = "AzureMonitor",
 *                     },
 *                 },
 *                 EmissionType = "IPFIX",
 *             },
 *         },
 *         IngestionPolicy = new AzureNative.NetworkFunction.Inputs.IngestionPolicyPropertiesFormatArgs
 *         {
 *             IngestionSources = new[]
 *             {
 *                 new AzureNative.NetworkFunction.Inputs.IngestionSourcesPropertiesFormatArgs
 *                 {
 *                     ResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName",
 *                     SourceType = "Resource",
 *                 },
 *             },
 *             IngestionType = "IPFIX",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkfunction/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfunction.NewCollectorPolicy(ctx, "collectorPolicy", &networkfunction.CollectorPolicyArgs{
 * 			AzureTrafficCollectorName: pulumi.String("atc"),
 * 			CollectorPolicyName:       pulumi.String("cp1"),
 * 			EmissionPolicies: []networkfunction.EmissionPoliciesPropertiesFormatArgs{
 * 				{
 * 					EmissionDestinations: networkfunction.EmissionPolicyDestinationArray{
 * 						{
 * 							DestinationType: pulumi.String("AzureMonitor"),
 * 						},
 * 					},
 * 					EmissionType: pulumi.String("IPFIX"),
 * 				},
 * 			},
 * 			IngestionPolicy: networkfunction.IngestionPolicyPropertiesFormatResponse{
 * 				IngestionSources: networkfunction.IngestionSourcesPropertiesFormatArray{
 * 					&networkfunction.IngestionSourcesPropertiesFormatArgs{
 * 						ResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
 * 						SourceType: pulumi.String("Resource"),
 * 					},
 * 				},
 * 				IngestionType: pulumi.String("IPFIX"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicy;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var collectorPolicy = new CollectorPolicy("collectorPolicy", CollectorPolicyArgs.builder()
 *             .azureTrafficCollectorName("atc")
 *             .collectorPolicyName("cp1")
 *             .emissionPolicies(Map.ofEntries(
 *                 Map.entry("emissionDestinations", Map.of("destinationType", "AzureMonitor")),
 *                 Map.entry("emissionType", "IPFIX")
 *             ))
 *             .ingestionPolicy(Map.ofEntries(
 *                 Map.entry("ingestionSources", Map.ofEntries(
 *                     Map.entry("resourceId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
 *                     Map.entry("sourceType", "Resource")
 *                 )),
 *                 Map.entry("ingestionType", "IPFIX")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkfunction:CollectorPolicy cp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}
 * ```
 */
public class CollectorPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.networkfunction.CollectorPolicy,
) : KotlinCustomResource(javaResource, CollectorPolicyMapper) {
    /**
     * Emission policies.
     */
    public val emissionPolicies: Output<List<EmissionPoliciesPropertiesFormatResponse>>?
        get() = javaResource.emissionPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        emissionPoliciesPropertiesFormatResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Ingestion policies.
     */
    public val ingestionPolicy: Output<IngestionPolicyPropertiesFormatResponse>?
        get() = javaResource.ingestionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ingestionPolicyPropertiesFormatResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<TrackedResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                trackedResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CollectorPolicyMapper : ResourceMapper<CollectorPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkfunction.CollectorPolicy::class == javaResource::class

    override fun map(javaResource: Resource): CollectorPolicy = CollectorPolicy(
        javaResource as
            com.pulumi.azurenative.networkfunction.CollectorPolicy,
    )
}

/**
 * @see [CollectorPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CollectorPolicy].
 */
public suspend fun collectorPolicy(
    name: String,
    block: suspend CollectorPolicyResourceBuilder.() -> Unit,
): CollectorPolicy {
    val builder = CollectorPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CollectorPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun collectorPolicy(name: String): CollectorPolicy {
    val builder = CollectorPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
