@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.IngestionPolicyPropertiesFormatArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.enums.IngestionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Ingestion Policy properties.
 * @property ingestionSources Ingestion Sources.
 * @property ingestionType The ingestion type.
 */
public data class IngestionPolicyPropertiesFormatArgs(
    public val ingestionSources: Output<List<IngestionSourcesPropertiesFormatArgs>>? = null,
    public val ingestionType: Output<Either<String, IngestionType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.IngestionPolicyPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkfunction.inputs.IngestionPolicyPropertiesFormatArgs =
        com.pulumi.azurenative.networkfunction.inputs.IngestionPolicyPropertiesFormatArgs.builder()
            .ingestionSources(
                ingestionSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingestionType(
                ingestionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IngestionPolicyPropertiesFormatArgs].
 */
@PulumiTagMarker
public class IngestionPolicyPropertiesFormatArgsBuilder internal constructor() {
    private var ingestionSources: Output<List<IngestionSourcesPropertiesFormatArgs>>? = null

    private var ingestionType: Output<Either<String, IngestionType>>? = null

    /**
     * @param value Ingestion Sources.
     */
    @JvmName("ykkfjypqmwwvhtmh")
    public suspend fun ingestionSources(`value`: Output<List<IngestionSourcesPropertiesFormatArgs>>) {
        this.ingestionSources = value
    }

    @JvmName("obtldjjunwkiuqfm")
    public suspend fun ingestionSources(vararg values: Output<IngestionSourcesPropertiesFormatArgs>) {
        this.ingestionSources = Output.all(values.asList())
    }

    /**
     * @param values Ingestion Sources.
     */
    @JvmName("hhmkhttuwrieshgk")
    public suspend fun ingestionSources(values: List<Output<IngestionSourcesPropertiesFormatArgs>>) {
        this.ingestionSources = Output.all(values)
    }

    /**
     * @param value The ingestion type.
     */
    @JvmName("hlpfwypexqxcyitw")
    public suspend fun ingestionType(`value`: Output<Either<String, IngestionType>>) {
        this.ingestionType = value
    }

    /**
     * @param value Ingestion Sources.
     */
    @JvmName("kydhfthkoccbywnj")
    public suspend fun ingestionSources(`value`: List<IngestionSourcesPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionSources = mapped
    }

    /**
     * @param argument Ingestion Sources.
     */
    @JvmName("cmhegfybscnpvvpu")
    public suspend
    fun ingestionSources(argument: List<suspend IngestionSourcesPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IngestionSourcesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ingestionSources = mapped
    }

    /**
     * @param argument Ingestion Sources.
     */
    @JvmName("ukqkbwshvbltuxqj")
    public suspend fun ingestionSources(
        vararg
        argument: suspend IngestionSourcesPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IngestionSourcesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ingestionSources = mapped
    }

    /**
     * @param argument Ingestion Sources.
     */
    @JvmName("nmjcanewdsspldfj")
    public suspend
    fun ingestionSources(argument: suspend IngestionSourcesPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IngestionSourcesPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingestionSources = mapped
    }

    /**
     * @param values Ingestion Sources.
     */
    @JvmName("ipsgruolmqolimng")
    public suspend fun ingestionSources(vararg values: IngestionSourcesPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionSources = mapped
    }

    /**
     * @param value The ingestion type.
     */
    @JvmName("uxvdtpanujqvjrid")
    public suspend fun ingestionType(`value`: Either<String, IngestionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    /**
     * @param value The ingestion type.
     */
    @JvmName("sqgyaeewdqxyxqeh")
    public fun ingestionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngestionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    /**
     * @param value The ingestion type.
     */
    @JvmName("txffdoluyessriid")
    public fun ingestionType(`value`: IngestionType) {
        val toBeMapped = Either.ofRight<String, IngestionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    internal fun build(): IngestionPolicyPropertiesFormatArgs = IngestionPolicyPropertiesFormatArgs(
        ingestionSources = ingestionSources,
        ingestionType = ingestionType,
    )
}
