@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Collector policy resource.
 * @property emissionPolicies Emission policies.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ingestionPolicy Ingestion policies.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetCollectorPolicyResult(
    public val emissionPolicies: List<EmissionPoliciesPropertiesFormatResponse>? = null,
    public val etag: String,
    public val id: String,
    public val ingestionPolicy: IngestionPolicyPropertiesFormatResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: TrackedResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkfunction.outputs.GetCollectorPolicyResult):
            GetCollectorPolicyResult = GetCollectorPolicyResult(
            emissionPolicies = javaType.emissionPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.EmissionPoliciesPropertiesFormatResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            ingestionPolicy = javaType.ingestionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.IngestionPolicyPropertiesFormatResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
