@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.kotlin.outputs.NamespacePropertiesResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.NamespacePropertiesResponse.Companion.toKotlin as namespacePropertiesResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource =
            com.pulumi.azurenative.notificationhubs.Namespace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Namespace(builtJavaResource)
    }
}

/**
 * Notification Hubs Namespace Resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.NotificationHubs.Namespace("namespace", new()
 *     {
 *         Location = "South Central US",
 *         NamespaceName = "nh-sdk-ns",
 *         Properties = new AzureNative.NotificationHubs.Inputs.NamespacePropertiesArgs
 *         {
 *             NetworkAcls = new AzureNative.NotificationHubs.Inputs.NetworkAclsArgs
 *             {
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.NotificationHubs.Inputs.IpRuleArgs
 *                     {
 *                         IpMask = "185.48.100.00/24",
 *                         Rights = new[]
 *                         {
 *                             "Manage",
 *                             "Send",
 *                             "Listen",
 *                         },
 *                     },
 *                 },
 *                 PublicNetworkRule = new AzureNative.NotificationHubs.Inputs.PublicInternetAuthorizationRuleArgs
 *                 {
 *                     Rights = new[]
 *                     {
 *                         "Listen",
 *                     },
 *                 },
 *             },
 *             ZoneRedundancy = "Enabled",
 *         },
 *         ResourceGroupName = "5ktrial",
 *         Sku = new AzureNative.NotificationHubs.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := notificationhubs.NewNamespace(ctx, "namespace", &notificationhubs.NamespaceArgs{
 * Location: pulumi.String("South Central US"),
 * NamespaceName: pulumi.String("nh-sdk-ns"),
 * Properties: notificationhubs.NamespacePropertiesResponse{
 * NetworkAcls: interface{}{
 * IpRules: notificationhubs.IpRuleArray{
 * &notificationhubs.IpRuleArgs{
 * IpMask: pulumi.String("185.48.100.00/24"),
 * Rights: pulumi.StringArray{
 * pulumi.String("Manage"),
 * pulumi.String("Send"),
 * pulumi.String("Listen"),
 * },
 * },
 * },
 * PublicNetworkRule: &notificationhubs.PublicInternetAuthorizationRuleArgs{
 * Rights: pulumi.StringArray{
 * pulumi.String("Listen"),
 * },
 * },
 * },
 * ZoneRedundancy: pulumi.String("Enabled"),
 * },
 * ResourceGroupName: pulumi.String("5ktrial"),
 * Sku: &notificationhubs.SkuArgs{
 * Name: pulumi.String("Standard"),
 * Tier: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "tag1": pulumi.String("value1"),
 * "tag2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.Namespace;
 * import com.pulumi.azurenative.notificationhubs.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("South Central US")
 *             .namespaceName("nh-sdk-ns")
 *             .properties(Map.ofEntries(
 *                 Map.entry("networkAcls", Map.ofEntries(
 *                     Map.entry("ipRules", Map.ofEntries(
 *                         Map.entry("ipMask", "185.48.100.00/24"),
 *                         Map.entry("rights",
 *                             "Manage",
 *                             "Send",
 *                             "Listen")
 *                     )),
 *                     Map.entry("publicNetworkRule", Map.of("rights", "Listen"))
 *                 )),
 *                 Map.entry("zoneRedundancy", "Enabled")
 *             ))
 *             .resourceGroupName("5ktrial")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:Namespace nh-sdk-ns /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}
 * ```
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.azurenative.notificationhubs.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Represents namespace properties.
     */
    public val properties: Output<NamespacePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                namespacePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The Sku description for a namespace
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.notificationhubs.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.azurenative.notificationhubs.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit):
    Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
