@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse.Companion.toKotlin as sharedAccessAuthorizationRulePropertiesResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NotificationHubAuthorizationRule].
 */
@PulumiTagMarker
public class NotificationHubAuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationHubAuthorizationRuleArgs = NotificationHubAuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationHubAuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = NotificationHubAuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotificationHubAuthorizationRule {
        val builtJavaResource =
            com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationHubAuthorizationRule(builtJavaResource)
    }
}

/**
 * Response for POST requests that return single SharedAccessAuthorizationRule.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2016-03-01, 2017-04-01, 2023-09-01.
 * ## Example Usage
 * ### NotificationHubs_CreateOrUpdateAuthorizationRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationHubAuthorizationRule = new AzureNative.NotificationHubs.NotificationHubAuthorizationRule("notificationHubAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "MyManageSharedAccessKey",
 *         NamespaceName = "nh-sdk-ns",
 *         NotificationHubName = "nh-sdk-hub",
 *         Properties = new AzureNative.NotificationHubs.Inputs.SharedAccessAuthorizationRulePropertiesArgs
 *         {
 *             Rights = new[]
 *             {
 *                 "Listen",
 *                 "Send",
 *             },
 *         },
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNotificationHubAuthorizationRule(ctx, "notificationHubAuthorizationRule", &notificationhubs.NotificationHubAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("MyManageSharedAccessKey"),
 * 			NamespaceName:         pulumi.String("nh-sdk-ns"),
 * 			NotificationHubName:   pulumi.String("nh-sdk-hub"),
 * 			Properties: &notificationhubs.SharedAccessAuthorizationRulePropertiesArgs{
 * 				Rights: pulumi.StringArray{
 * 					pulumi.String("Listen"),
 * 					pulumi.String("Send"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRule;
 * import com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationHubAuthorizationRule = new NotificationHubAuthorizationRule("notificationHubAuthorizationRule", NotificationHubAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("MyManageSharedAccessKey")
 *             .namespaceName("nh-sdk-ns")
 *             .notificationHubName("nh-sdk-hub")
 *             .properties(Map.of("rights",
 *                 "Listen",
 *                 "Send"))
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:NotificationHubAuthorizationRule MyManageSharedAccessKey /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/authorizationRules/{authorizationRuleName}
 * ```
 */
public class NotificationHubAuthorizationRule internal constructor(
    override val javaResource:
    com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRule,
) : KotlinCustomResource(javaResource, NotificationHubAuthorizationRuleMapper) {
    /**
     * Deprecated - only for compatibility.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SharedAccessAuthorizationRule properties.
     */
    public val properties: Output<SharedAccessAuthorizationRulePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sharedAccessAuthorizationRulePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Deprecated - only for compatibility.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NotificationHubAuthorizationRuleMapper :
    ResourceMapper<NotificationHubAuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): NotificationHubAuthorizationRule =
        NotificationHubAuthorizationRule(
            javaResource as
                com.pulumi.azurenative.notificationhubs.NotificationHubAuthorizationRule,
        )
}

/**
 * @see [NotificationHubAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationHubAuthorizationRule].
 */
public suspend fun notificationHubAuthorizationRule(
    name: String,
    block: suspend NotificationHubAuthorizationRuleResourceBuilder.() -> Unit,
):
    NotificationHubAuthorizationRule {
    val builder = NotificationHubAuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationHubAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationHubAuthorizationRule(name: String): NotificationHubAuthorizationRule {
    val builder = NotificationHubAuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
