@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.PrivateEndpointConnectionPropertiesArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.PrivateEndpointConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a Private Endpoint Connection ARM resource - a sub-resource of Notification Hubs namespace.
 * Azure REST API version: 2023-01-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### PrivateEndpointConnections_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.NotificationHubs.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         NamespaceName = "nh-sdk-ns",
 *         PrivateEndpointConnectionName = "nh-sdk-ns.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *         Properties = new AzureNative.NotificationHubs.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.NotificationHubs.Inputs.RemotePrivateLinkServiceConnectionStateArgs
 *             {
 *                 Status = "Approved",
 *             },
 *         },
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &notificationhubs.PrivateEndpointConnectionArgs{
 * 			NamespaceName:                 pulumi.String("nh-sdk-ns"),
 * 			PrivateEndpointConnectionName: pulumi.String("nh-sdk-ns.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * 			Properties: notificationhubs.PrivateEndpointConnectionPropertiesResponse{
 * 				PrivateLinkServiceConnectionState: &notificationhubs.RemotePrivateLinkServiceConnectionStateArgs{
 * 					Status: pulumi.String("Approved"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.PrivateEndpointConnection;
 * import com.pulumi.azurenative.notificationhubs.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .namespaceName("nh-sdk-ns")
 *             .privateEndpointConnectionName("nh-sdk-ns.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *             .properties(Map.of("privateLinkServiceConnectionState", Map.of("status", "Approved")))
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:PrivateEndpointConnection nh-sdk-ns.1fa229cd-bf3f-47f0-8c49-afb36723997e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property namespaceName Namespace name
 * @property privateEndpointConnectionName Private Endpoint Connection Name
 * @property properties Private Endpoint Connection properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val namespaceName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.notificationhubs.PrivateEndpointConnectionArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Namespace name
     */
    @JvmName("gjcmimmheahoivhi")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Private Endpoint Connection Name
     */
    @JvmName("frspoajlntmppdcf")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Private Endpoint Connection properties.
     */
    @JvmName("yncjnhalppewafml")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kirqnmpuatexrmrb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Namespace name
     */
    @JvmName("iowljphmemoothqo")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Private Endpoint Connection Name
     */
    @JvmName("wlxnvxeeevubexto")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Private Endpoint Connection properties.
     */
    @JvmName("ivjennqirrsibuuy")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Private Endpoint Connection properties.
     */
    @JvmName("pcmixqobwdurdmwa")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oiahxwcbfstymagg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        namespaceName = namespaceName,
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
