@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub AdmCredential.
 * @property properties Description of a NotificationHub AdmCredential.
 */
public data class AdmCredentialArgs(
    public val properties: Output<AdmCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AdmCredentialArgs].
 */
@PulumiTagMarker
public class AdmCredentialArgsBuilder internal constructor() {
    private var properties: Output<AdmCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub AdmCredential.
     */
    @JvmName("mswhggwvulogwcui")
    public suspend fun properties(`value`: Output<AdmCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub AdmCredential.
     */
    @JvmName("klmcyjeyxfpvvnpe")
    public suspend fun properties(`value`: AdmCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub AdmCredential.
     */
    @JvmName("bqncucpcywarcvdr")
    public suspend fun properties(argument: suspend AdmCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AdmCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): AdmCredentialArgs = AdmCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
