@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub ApnsCredential.
 * @property apnsCertificate Gets or sets the APNS certificate.
 * @property appId Gets or sets the issuer (iss) registered claim key, whose value is
 * your 10-character Team ID, obtained from your developer account
 * @property appName Gets or sets the name of the application
 * @property certificateKey Gets or sets the certificate key.
 * @property endpoint Gets or sets the endpoint of this credential.
 * @property keyId Gets or sets a 10-character key identifier (kid) key, obtained from
 * your developer account
 * @property thumbprint Gets or sets the APNS certificate Thumbprint
 * @property token Gets or sets provider Authentication Token, obtained through your
 * developer account
 */
public data class ApnsCredentialPropertiesArgs(
    public val apnsCertificate: Output<String>? = null,
    public val appId: Output<String>? = null,
    public val appName: Output<String>? = null,
    public val certificateKey: Output<String>? = null,
    public val endpoint: Output<String>,
    public val keyId: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
    public val token: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialPropertiesArgs.builder()
            .apnsCertificate(apnsCertificate?.applyValue({ args0 -> args0 }))
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appName(appName?.applyValue({ args0 -> args0 }))
            .certificateKey(certificateKey?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApnsCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class ApnsCredentialPropertiesArgsBuilder internal constructor() {
    private var apnsCertificate: Output<String>? = null

    private var appId: Output<String>? = null

    private var appName: Output<String>? = null

    private var certificateKey: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var keyId: Output<String>? = null

    private var thumbprint: Output<String>? = null

    private var token: Output<String>? = null

    /**
     * @param value Gets or sets the APNS certificate.
     */
    @JvmName("flhwnwuqlsvjedhc")
    public suspend fun apnsCertificate(`value`: Output<String>) {
        this.apnsCertificate = value
    }

    /**
     * @param value Gets or sets the issuer (iss) registered claim key, whose value is
     * your 10-character Team ID, obtained from your developer account
     */
    @JvmName("jrvtqcsgvfuyanom")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Gets or sets the name of the application
     */
    @JvmName("rkryrlmwbucyymeg")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Gets or sets the certificate key.
     */
    @JvmName("jlugbjvjaayxovdb")
    public suspend fun certificateKey(`value`: Output<String>) {
        this.certificateKey = value
    }

    /**
     * @param value Gets or sets the endpoint of this credential.
     */
    @JvmName("ffbdqounxfywiqrg")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Gets or sets a 10-character key identifier (kid) key, obtained from
     * your developer account
     */
    @JvmName("wfmphnaqvwuhshfs")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Gets or sets the APNS certificate Thumbprint
     */
    @JvmName("fbufqvklqvjbajfe")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Gets or sets provider Authentication Token, obtained through your
     * developer account
     */
    @JvmName("tvxthdrfvjokckqy")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Gets or sets the APNS certificate.
     */
    @JvmName("wgmxdhubjalswhnu")
    public suspend fun apnsCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apnsCertificate = mapped
    }

    /**
     * @param value Gets or sets the issuer (iss) registered claim key, whose value is
     * your 10-character Team ID, obtained from your developer account
     */
    @JvmName("minwlwwdkfuerdon")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Gets or sets the name of the application
     */
    @JvmName("qglldiunhnnkgcyl")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Gets or sets the certificate key.
     */
    @JvmName("nxakloaukjmrqfma")
    public suspend fun certificateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateKey = mapped
    }

    /**
     * @param value Gets or sets the endpoint of this credential.
     */
    @JvmName("wovmdnjksndihcif")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Gets or sets a 10-character key identifier (kid) key, obtained from
     * your developer account
     */
    @JvmName("dnjebvjmtlgxjatk")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Gets or sets the APNS certificate Thumbprint
     */
    @JvmName("areokvkhymnyodaa")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    /**
     * @param value Gets or sets provider Authentication Token, obtained through your
     * developer account
     */
    @JvmName("rwfvvayyweqrjjtq")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): ApnsCredentialPropertiesArgs = ApnsCredentialPropertiesArgs(
        apnsCertificate = apnsCertificate,
        appId = appId,
        appName = appName,
        certificateKey = certificateKey,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        keyId = keyId,
        thumbprint = thumbprint,
        token = token,
    )
}
