@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub BrowserCredential.
 * @property subject Gets or sets web push subject.
 * @property vapidPrivateKey Gets or sets VAPID private key.
 * @property vapidPublicKey Gets or sets VAPID public key.
 */
public data class BrowserCredentialPropertiesArgs(
    public val subject: Output<String>,
    public val vapidPrivateKey: Output<String>,
    public val vapidPublicKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialPropertiesArgs.builder()
            .subject(subject.applyValue({ args0 -> args0 }))
            .vapidPrivateKey(vapidPrivateKey.applyValue({ args0 -> args0 }))
            .vapidPublicKey(vapidPublicKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrowserCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class BrowserCredentialPropertiesArgsBuilder internal constructor() {
    private var subject: Output<String>? = null

    private var vapidPrivateKey: Output<String>? = null

    private var vapidPublicKey: Output<String>? = null

    /**
     * @param value Gets or sets web push subject.
     */
    @JvmName("ijxdobmrlheanfrm")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value Gets or sets VAPID private key.
     */
    @JvmName("tcmmfcnsnbciuocp")
    public suspend fun vapidPrivateKey(`value`: Output<String>) {
        this.vapidPrivateKey = value
    }

    /**
     * @param value Gets or sets VAPID public key.
     */
    @JvmName("isibixdrahvklibi")
    public suspend fun vapidPublicKey(`value`: Output<String>) {
        this.vapidPublicKey = value
    }

    /**
     * @param value Gets or sets web push subject.
     */
    @JvmName("cvwshyslgiicsrcj")
    public suspend fun subject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value Gets or sets VAPID private key.
     */
    @JvmName("vrrnnuxgandpmfxp")
    public suspend fun vapidPrivateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vapidPrivateKey = mapped
    }

    /**
     * @param value Gets or sets VAPID public key.
     */
    @JvmName("wvijnnmcajrajxke")
    public suspend fun vapidPublicKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vapidPublicKey = mapped
    }

    internal fun build(): BrowserCredentialPropertiesArgs = BrowserCredentialPropertiesArgs(
        subject = subject ?: throw PulumiNullFieldException("subject"),
        vapidPrivateKey = vapidPrivateKey ?: throw PulumiNullFieldException("vapidPrivateKey"),
        vapidPublicKey = vapidPublicKey ?: throw PulumiNullFieldException("vapidPublicKey"),
    )
}
