@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.IpRuleArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A network authorization rule that filters traffic based on IP address.
 * @property ipMask IP mask.
 * @property rights List of access rights.
 */
public data class IpRuleArgs(
    public val ipMask: Output<String>,
    public val rights: Output<List<Either<String, AccessRights>>>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.IpRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.IpRuleArgs =
        com.pulumi.azurenative.notificationhubs.inputs.IpRuleArgs.builder()
            .ipMask(ipMask.applyValue({ args0 -> args0 }))
            .rights(
                rights.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [IpRuleArgs].
 */
@PulumiTagMarker
public class IpRuleArgsBuilder internal constructor() {
    private var ipMask: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value IP mask.
     */
    @JvmName("cfbwtpsycwyctrci")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value List of access rights.
     */
    @JvmName("gavhrgdjadbtwhcj")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("duglbtxingkrhyrk")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values List of access rights.
     */
    @JvmName("brhopbqurdoplrow")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value IP mask.
     */
    @JvmName("ndckyntuddpaxqli")
    public suspend fun ipMask(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    /**
     * @param value List of access rights.
     */
    @JvmName("rpwjrgoudxbftwam")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values List of access rights.
     */
    @JvmName("gpbwcsslxwywcchf")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): IpRuleArgs = IpRuleArgs(
        ipMask = ipMask ?: throw PulumiNullFieldException("ipMask"),
        rights = rights ?: throw PulumiNullFieldException("rights"),
    )
}
