@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub MpnsCredential.
 * @property properties Description of a NotificationHub MpnsCredential.
 */
public data class MpnsCredentialArgs(
    public val properties: Output<MpnsCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MpnsCredentialArgs].
 */
@PulumiTagMarker
public class MpnsCredentialArgsBuilder internal constructor() {
    private var properties: Output<MpnsCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub MpnsCredential.
     */
    @JvmName("yyrwnhlwgquorpkf")
    public suspend fun properties(`value`: Output<MpnsCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub MpnsCredential.
     */
    @JvmName("qrqmumlaasmyuplx")
    public suspend fun properties(`value`: MpnsCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub MpnsCredential.
     */
    @JvmName("xnhwdbywpemggwqt")
    public suspend fun properties(argument: suspend MpnsCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MpnsCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): MpnsCredentialArgs = MpnsCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
