@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.PrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.PrivateEndpointConnectionProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private Endpoint Connection properties.
 * @property privateLinkServiceConnectionState State of the Private Link Service connection.
 * @property provisioningState State of Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionPropertiesArgs(
    public val privateLinkServiceConnectionState: Output<RemotePrivateLinkServiceConnectionStateArgs>? =
        null,
    public val provisioningState: Output<Either<String, PrivateEndpointConnectionProvisioningState>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.PrivateEndpointConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.PrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.PrivateEndpointConnectionPropertiesArgs.builder()
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var privateLinkServiceConnectionState:
        Output<RemotePrivateLinkServiceConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, PrivateEndpointConnectionProvisioningState>>? =
        null

    /**
     * @param value State of the Private Link Service connection.
     */
    @JvmName("elghfmdiqetcncwg")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<RemotePrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value State of Private Endpoint Connection.
     */
    @JvmName("wmcgpvdrdwcjeupo")
    public suspend
    fun provisioningState(`value`: Output<Either<String, PrivateEndpointConnectionProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value State of the Private Link Service connection.
     */
    @JvmName("ymhdxsxhtvfvqxuk")
    public suspend
    fun privateLinkServiceConnectionState(`value`: RemotePrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument State of the Private Link Service connection.
     */
    @JvmName("hgbpkefitxdfvidh")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend RemotePrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = RemotePrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value State of Private Endpoint Connection.
     */
    @JvmName("ucwmqrplqmnypweg")
    public suspend
    fun provisioningState(`value`: Either<String, PrivateEndpointConnectionProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value State of Private Endpoint Connection.
     */
    @JvmName("ktpdiupbmetwbamu")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointConnectionProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value State of Private Endpoint Connection.
     */
    @JvmName("ntgjclhtrecllqne")
    public fun provisioningState(`value`: PrivateEndpointConnectionProvisioningState) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointConnectionProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesArgs =
        PrivateEndpointConnectionPropertiesArgs(
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            provisioningState = provisioningState,
        )
}
