@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.SkuArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Sku description for a namespace
 * @property capacity Gets or sets the capacity of the resource
 * @property family Gets or sets the Sku Family
 * @property name Namespace SKU name.
 * @property size Gets or sets the Sku size
 * @property tier Gets or sets the tier of particular sku
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<Either<String, SkuName>>,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.SkuArgs =
        com.pulumi.azurenative.notificationhubs.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<Either<String, SkuName>>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Gets or sets the capacity of the resource
     */
    @JvmName("xesexqsgvgpchdbk")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Gets or sets the Sku Family
     */
    @JvmName("fubixinwlguvsgtx")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("jscixlkimvpsuuhb")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the Sku size
     */
    @JvmName("jbneygabblluptwx")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value Gets or sets the tier of particular sku
     */
    @JvmName("jhchwtpliwwtrqsr")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Gets or sets the capacity of the resource
     */
    @JvmName("caeaewityfwatcoc")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Gets or sets the Sku Family
     */
    @JvmName("rmxqllbbrcvgjooy")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("uqqtxynjuwjokldm")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("eiqpqfsrwevbksbr")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("bgrglbyndtkjutmv")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the Sku size
     */
    @JvmName("vyyjrccogpsdbeol")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Gets or sets the tier of particular sku
     */
    @JvmName("pasivskoyeaqpcuu")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
