@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub WnsCredential.
 * @property properties Description of a NotificationHub WnsCredential.
 */
public data class WnsCredentialArgs(
    public val properties: Output<WnsCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WnsCredentialArgs].
 */
@PulumiTagMarker
public class WnsCredentialArgsBuilder internal constructor() {
    private var properties: Output<WnsCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub WnsCredential.
     */
    @JvmName("cgwkjurflqbxcgok")
    public suspend fun properties(`value`: Output<WnsCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub WnsCredential.
     */
    @JvmName("fdsbcrombafqwuqu")
    public suspend fun properties(`value`: WnsCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub WnsCredential.
     */
    @JvmName("loywsnnrwkecydpm")
    public suspend fun properties(argument: suspend WnsCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WnsCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): WnsCredentialArgs = WnsCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
