@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub XiaomiCredential.
 * @property properties Description of a NotificationHub XiaomiCredentialProperties.
 */
public data class XiaomiCredentialArgs(
    public val properties: Output<XiaomiCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [XiaomiCredentialArgs].
 */
@PulumiTagMarker
public class XiaomiCredentialArgsBuilder internal constructor() {
    private var properties: Output<XiaomiCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub XiaomiCredentialProperties.
     */
    @JvmName("txmtaiurlkqrfyvy")
    public suspend fun properties(`value`: Output<XiaomiCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub XiaomiCredentialProperties.
     */
    @JvmName("rggpxbuwdkuvmopw")
    public suspend fun properties(`value`: XiaomiCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub XiaomiCredentialProperties.
     */
    @JvmName("srnjwmpdwwxaalfi")
    public suspend
    fun properties(argument: suspend XiaomiCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = XiaomiCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): XiaomiCredentialArgs = XiaomiCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
