@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Suppress

/**
 * Collection of Notification Hub or Notification Hub Namespace PNS credentials.
 * @property admCredential Description of a NotificationHub AdmCredential.
 * @property apnsCredential Description of a NotificationHub ApnsCredential.
 * @property baiduCredential Description of a NotificationHub BaiduCredential.
 * @property browserCredential Description of a NotificationHub BrowserCredential.
 * @property gcmCredential Description of a NotificationHub GcmCredential.
 * @property mpnsCredential Description of a NotificationHub MpnsCredential.
 * @property wnsCredential Description of a NotificationHub WnsCredential.
 * @property xiaomiCredential Description of a NotificationHub XiaomiCredential.
 */
public data class PnsCredentialsResponse(
    public val admCredential: AdmCredentialResponse? = null,
    public val apnsCredential: ApnsCredentialResponse? = null,
    public val baiduCredential: BaiduCredentialResponse? = null,
    public val browserCredential: BrowserCredentialResponse? = null,
    public val gcmCredential: GcmCredentialResponse? = null,
    public val mpnsCredential: MpnsCredentialResponse? = null,
    public val wnsCredential: WnsCredentialResponse? = null,
    public val xiaomiCredential: XiaomiCredentialResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.PnsCredentialsResponse):
            PnsCredentialsResponse = PnsCredentialsResponse(
            admCredential = javaType.admCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.AdmCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apnsCredential = javaType.apnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.ApnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            baiduCredential = javaType.baiduCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.BaiduCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            browserCredential = javaType.browserCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.BrowserCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gcmCredential = javaType.gcmCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.GcmCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mpnsCredential = javaType.mpnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.MpnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            wnsCredential = javaType.wnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.WnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            xiaomiCredential = javaType.xiaomiCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.XiaomiCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
