@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.MasterSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.MasterSitePropertiesPublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A MasterSite
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### MasterSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var masterSitesController = new AzureNative.OffAzure.MasterSitesController("masterSitesController", new()
 *     {
 *         AllowMultipleSites = true,
 *         CustomerStorageAccountArmId = "cdxrihtiskkn",
 *         Location = "plyak",
 *         PublicNetworkAccess = "NotSpecified",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "74c1J1m56557t52H-75",
 *         Sites = new[]
 *         {
 *             "zxupfq",
 *         },
 *         Tags =
 *         {
 *             { "key7125", "jbhnzfuxjovyamasouyfhhzhevagvw" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewMasterSitesController(ctx, "masterSitesController", &offazure.MasterSitesControllerArgs{
 * 			AllowMultipleSites:          pulumi.Bool(true),
 * 			CustomerStorageAccountArmId: pulumi.String("cdxrihtiskkn"),
 * 			Location:                    pulumi.String("plyak"),
 * 			PublicNetworkAccess:         pulumi.String("NotSpecified"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("74c1J1m56557t52H-75"),
 * 			Sites: pulumi.StringArray{
 * 				pulumi.String("zxupfq"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key7125": pulumi.String("jbhnzfuxjovyamasouyfhhzhevagvw"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.MasterSitesController;
 * import com.pulumi.azurenative.offazure.MasterSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var masterSitesController = new MasterSitesController("masterSitesController", MasterSitesControllerArgs.builder()
 *             .allowMultipleSites(true)
 *             .customerStorageAccountArmId("cdxrihtiskkn")
 *             .location("plyak")
 *             .publicNetworkAccess("NotSpecified")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("74c1J1m56557t52H-75")
 *             .sites("zxupfq")
 *             .tags(Map.of("key7125", "jbhnzfuxjovyamasouyfhhzhevagvw"))
 *             .build());
 *     }
 * }
 * ```
 * ### MasterSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var masterSitesController = new AzureNative.OffAzure.MasterSitesController("masterSitesController", new()
 *     {
 *         Location = "plyak",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-3A8SuY-jRr63J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewMasterSitesController(ctx, "masterSitesController", &offazure.MasterSitesControllerArgs{
 * 			Location:          pulumi.String("plyak"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("-3A8SuY-jRr63J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.MasterSitesController;
 * import com.pulumi.azurenative.offazure.MasterSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var masterSitesController = new MasterSitesController("masterSitesController", MasterSitesControllerArgs.builder()
 *             .location("plyak")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-3A8SuY-jRr63J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:MasterSitesController asmdtexbhrvpepiavab /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}
 * ```
 * @property allowMultipleSites Gets or sets a value indicating whether multiple sites per site type are
 * allowed.
 * @property customerStorageAccountArmId Gets or sets a value for customer storage account ARM id.
 * @property location The geo-location where the resource lives
 * @property publicNetworkAccess Gets or sets the state of public network access.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property sites Gets or sets the sites that are a part of Master Site.
 *             The key
 * should contain the Site ARM name.
 * @property tags Resource tags.
 */
public data class MasterSitesControllerArgs(
    public val allowMultipleSites: Output<Boolean>? = null,
    public val customerStorageAccountArmId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, MasterSitePropertiesPublicNetworkAccess>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val sites: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.MasterSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.MasterSitesControllerArgs =
        com.pulumi.azurenative.offazure.MasterSitesControllerArgs.builder()
            .allowMultipleSites(allowMultipleSites?.applyValue({ args0 -> args0 }))
            .customerStorageAccountArmId(customerStorageAccountArmId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .sites(sites?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MasterSitesControllerArgs].
 */
@PulumiTagMarker
public class MasterSitesControllerArgsBuilder internal constructor() {
    private var allowMultipleSites: Output<Boolean>? = null

    private var customerStorageAccountArmId: Output<String>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, MasterSitePropertiesPublicNetworkAccess>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var sites: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Gets or sets a value indicating whether multiple sites per site type are
     * allowed.
     */
    @JvmName("vweqhrroedqhsleq")
    public suspend fun allowMultipleSites(`value`: Output<Boolean>) {
        this.allowMultipleSites = value
    }

    /**
     * @param value Gets or sets a value for customer storage account ARM id.
     */
    @JvmName("bjbvjfjadmuijfet")
    public suspend fun customerStorageAccountArmId(`value`: Output<String>) {
        this.customerStorageAccountArmId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("whboloicostmfjdw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("inbhfyvlsbigtihr")
    public suspend
    fun publicNetworkAccess(`value`: Output<Either<String, MasterSitePropertiesPublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qckcpxnuukksxkyo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name
     */
    @JvmName("fewryxdycekjxtbl")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Gets or sets the sites that are a part of Master Site.
     *             The key
     * should contain the Site ARM name.
     */
    @JvmName("lhsmjgvqdlyeosyn")
    public suspend fun sites(`value`: Output<List<String>>) {
        this.sites = value
    }

    @JvmName("tkebynalvsqrulfw")
    public suspend fun sites(vararg values: Output<String>) {
        this.sites = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the sites that are a part of Master Site.
     *             The key
     * should contain the Site ARM name.
     */
    @JvmName("pdvewtajallkxmcx")
    public suspend fun sites(values: List<Output<String>>) {
        this.sites = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("juhgdolhtqkbbxbw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets a value indicating whether multiple sites per site type are
     * allowed.
     */
    @JvmName("yotoljauuhegoigm")
    public suspend fun allowMultipleSites(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMultipleSites = mapped
    }

    /**
     * @param value Gets or sets a value for customer storage account ARM id.
     */
    @JvmName("mpqaykqvwhlcjkgh")
    public suspend fun customerStorageAccountArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerStorageAccountArmId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dhvoydwkgvhqkcvr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("fugqrkcuqmovnbyf")
    public suspend
    fun publicNetworkAccess(`value`: Either<String, MasterSitePropertiesPublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("hsfkjefekcuvnaji")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MasterSitePropertiesPublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("cfjlcwwgreoglcua")
    public fun publicNetworkAccess(`value`: MasterSitePropertiesPublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, MasterSitePropertiesPublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hludttwplacsawbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("cvojgvwxaenxbwet")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Gets or sets the sites that are a part of Master Site.
     *             The key
     * should contain the Site ARM name.
     */
    @JvmName("srtmtbmryfwqdori")
    public suspend fun sites(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param values Gets or sets the sites that are a part of Master Site.
     *             The key
     * should contain the Site ARM name.
     */
    @JvmName("ymqtqcjvqkfvxbdh")
    public suspend fun sites(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tuprekflimfyvjjy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cmfcmnddwmddnycl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MasterSitesControllerArgs = MasterSitesControllerArgs(
        allowMultipleSites = allowMultipleSites,
        customerStorageAccountArmId = customerStorageAccountArmId,
        location = location,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        sites = sites,
        tags = tags,
    )
}
