@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.OffazureFunctions.getHyperVSitePlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getHypervClusterControllerClusterPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getHypervHostControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getHypervSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getImportSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getMasterSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getPrivateEndpointConnectionControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getServerSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getSitePlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getSqlDiscoverySiteDataSourceControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getSqlSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getVcenterControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getWebAppDiscoverySiteDataSourcesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.getWebAppSitesControllerPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.listHypervSitesControllerHealthSummaryPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.listServerSitesControllerHealthSummaryPlain
import com.pulumi.azurenative.offazure.OffazureFunctions.listSitesControllerHealthSummaryPlain
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHyperVSitePlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHyperVSitePlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervClusterControllerClusterPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervClusterControllerClusterPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervHostControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervHostControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetHypervSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetImportSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetImportSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetMasterSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetMasterSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetPrivateEndpointConnectionControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetPrivateEndpointConnectionControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetServerSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetServerSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSitePlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSqlSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetSqlSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetVcenterControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetVcenterControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.GetWebAppSitesControllerPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.GetWebAppSitesControllerPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.ListHypervSitesControllerHealthSummaryPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.ListHypervSitesControllerHealthSummaryPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.ListServerSitesControllerHealthSummaryPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.ListServerSitesControllerHealthSummaryPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.ListSitesControllerHealthSummaryPlainArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.ListSitesControllerHealthSummaryPlainArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHyperVSiteResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervClusterControllerClusterResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervHostControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetImportSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetMasterSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetPrivateEndpointConnectionControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetServerSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSiteResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSqlDiscoverySiteDataSourceControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSqlSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetVcenterControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetWebAppDiscoverySiteDataSourcesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.GetWebAppSitesControllerResult
import com.pulumi.azurenative.offazure.kotlin.outputs.ListHypervSitesControllerHealthSummaryResult
import com.pulumi.azurenative.offazure.kotlin.outputs.ListServerSitesControllerHealthSummaryResult
import com.pulumi.azurenative.offazure.kotlin.outputs.ListSitesControllerHealthSummaryResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHyperVSiteResult.Companion.toKotlin as getHyperVSiteResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervClusterControllerClusterResult.Companion.toKotlin as getHypervClusterControllerClusterResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervHostControllerResult.Companion.toKotlin as getHypervHostControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetHypervSitesControllerResult.Companion.toKotlin as getHypervSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetImportSitesControllerResult.Companion.toKotlin as getImportSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetMasterSitesControllerResult.Companion.toKotlin as getMasterSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetPrivateEndpointConnectionControllerResult.Companion.toKotlin as getPrivateEndpointConnectionControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetServerSitesControllerResult.Companion.toKotlin as getServerSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSitesControllerResult.Companion.toKotlin as getSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSqlDiscoverySiteDataSourceControllerResult.Companion.toKotlin as getSqlDiscoverySiteDataSourceControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetSqlSitesControllerResult.Companion.toKotlin as getSqlSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetVcenterControllerResult.Companion.toKotlin as getVcenterControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetWebAppDiscoverySiteDataSourcesControllerResult.Companion.toKotlin as getWebAppDiscoverySiteDataSourcesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.GetWebAppSitesControllerResult.Companion.toKotlin as getWebAppSitesControllerResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.ListHypervSitesControllerHealthSummaryResult.Companion.toKotlin as listHypervSitesControllerHealthSummaryResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.ListServerSitesControllerHealthSummaryResult.Companion.toKotlin as listServerSitesControllerHealthSummaryResultToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.ListSitesControllerHealthSummaryResult.Companion.toKotlin as listSitesControllerHealthSummaryResultToKotlin

public object OffazureFunctions {
    /**
     * Site REST Resource.
     * Azure REST API version: 2020-07-07.
     * @param argument null
     * @return Site REST Resource.
     */
    public suspend fun getHyperVSite(argument: GetHyperVSitePlainArgs): GetHyperVSiteResult =
        getHyperVSiteResultToKotlin(getHyperVSitePlain(argument.toJava()).await())

    /**
     * @see [getHyperVSite].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name.
     * @return Site REST Resource.
     */
    public suspend fun getHyperVSite(resourceGroupName: String, siteName: String):
        GetHyperVSiteResult {
        val argument = GetHyperVSitePlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getHyperVSiteResultToKotlin(getHyperVSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getHyperVSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetHyperVSitePlainArgs].
     * @return Site REST Resource.
     */
    public suspend fun getHyperVSite(argument: suspend GetHyperVSitePlainArgsBuilder.() -> Unit):
        GetHyperVSiteResult {
        val builder = GetHyperVSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHyperVSiteResultToKotlin(getHyperVSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get a Hyper-V cluster.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A cluster resource belonging to a site resource.
     */
    public suspend
    fun getHypervClusterControllerCluster(argument: GetHypervClusterControllerClusterPlainArgs):
        GetHypervClusterControllerClusterResult =
        getHypervClusterControllerClusterResultToKotlin(getHypervClusterControllerClusterPlain(argument.toJava()).await())

    /**
     * @see [getHypervClusterControllerCluster].
     * @param clusterName  Cluster ARM name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A cluster resource belonging to a site resource.
     */
    public suspend fun getHypervClusterControllerCluster(
        clusterName: String,
        resourceGroupName: String,
        siteName: String,
    ): GetHypervClusterControllerClusterResult {
        val argument = GetHypervClusterControllerClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getHypervClusterControllerClusterResultToKotlin(getHypervClusterControllerClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getHypervClusterControllerCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetHypervClusterControllerClusterPlainArgs].
     * @return A cluster resource belonging to a site resource.
     */
    public suspend
    fun getHypervClusterControllerCluster(argument: suspend GetHypervClusterControllerClusterPlainArgsBuilder.() -> Unit):
        GetHypervClusterControllerClusterResult {
        val builder = GetHypervClusterControllerClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHypervClusterControllerClusterResultToKotlin(getHypervClusterControllerClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a HypervHost
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A host resource belonging to a site resource.
     */
    public suspend fun getHypervHostController(argument: GetHypervHostControllerPlainArgs):
        GetHypervHostControllerResult =
        getHypervHostControllerResultToKotlin(getHypervHostControllerPlain(argument.toJava()).await())

    /**
     * @see [getHypervHostController].
     * @param hostName  Host name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A host resource belonging to a site resource.
     */
    public suspend fun getHypervHostController(
        hostName: String,
        resourceGroupName: String,
        siteName: String,
    ): GetHypervHostControllerResult {
        val argument = GetHypervHostControllerPlainArgs(
            hostName = hostName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getHypervHostControllerResultToKotlin(getHypervHostControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getHypervHostController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetHypervHostControllerPlainArgs].
     * @return A host resource belonging to a site resource.
     */
    public suspend
    fun getHypervHostController(argument: suspend GetHypervHostControllerPlainArgsBuilder.() -> Unit):
        GetHypervHostControllerResult {
        val builder = GetHypervHostControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHypervHostControllerResultToKotlin(getHypervHostControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a HypervSite
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A HyperV SiteResource
     */
    public suspend fun getHypervSitesController(argument: GetHypervSitesControllerPlainArgs):
        GetHypervSitesControllerResult =
        getHypervSitesControllerResultToKotlin(getHypervSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getHypervSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A HyperV SiteResource
     */
    public suspend fun getHypervSitesController(resourceGroupName: String, siteName: String):
        GetHypervSitesControllerResult {
        val argument = GetHypervSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getHypervSitesControllerResultToKotlin(getHypervSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getHypervSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetHypervSitesControllerPlainArgs].
     * @return A HyperV SiteResource
     */
    public suspend
    fun getHypervSitesController(argument: suspend GetHypervSitesControllerPlainArgsBuilder.() -> Unit):
        GetHypervSitesControllerResult {
        val builder = GetHypervSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHypervSitesControllerResultToKotlin(getHypervSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ImportSite
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A ImportSite
     */
    public suspend fun getImportSitesController(argument: GetImportSitesControllerPlainArgs):
        GetImportSitesControllerResult =
        getImportSitesControllerResultToKotlin(getImportSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getImportSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A ImportSite
     */
    public suspend fun getImportSitesController(resourceGroupName: String, siteName: String):
        GetImportSitesControllerResult {
        val argument = GetImportSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getImportSitesControllerResultToKotlin(getImportSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getImportSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetImportSitesControllerPlainArgs].
     * @return A ImportSite
     */
    public suspend
    fun getImportSitesController(argument: suspend GetImportSitesControllerPlainArgsBuilder.() -> Unit):
        GetImportSitesControllerResult {
        val builder = GetImportSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImportSitesControllerResultToKotlin(getImportSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a MasterSite
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A MasterSite
     */
    public suspend fun getMasterSitesController(argument: GetMasterSitesControllerPlainArgs):
        GetMasterSitesControllerResult =
        getMasterSitesControllerResultToKotlin(getMasterSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getMasterSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A MasterSite
     */
    public suspend fun getMasterSitesController(resourceGroupName: String, siteName: String):
        GetMasterSitesControllerResult {
        val argument = GetMasterSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getMasterSitesControllerResultToKotlin(getMasterSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getMasterSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetMasterSitesControllerPlainArgs].
     * @return A MasterSite
     */
    public suspend
    fun getMasterSitesController(argument: suspend GetMasterSitesControllerPlainArgsBuilder.() -> Unit):
        GetMasterSitesControllerResult {
        val builder = GetMasterSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMasterSitesControllerResultToKotlin(getMasterSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * REST model used to encapsulate the user visible state of a PrivateEndpoint.
     * Azure REST API version: 2020-07-07.
     * @param argument null
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param peConnectionName Private link resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name.
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend fun getPrivateEndpointConnection(
        peConnectionName: String,
        resourceGroupName: String,
        siteName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            peConnectionName = peConnectionName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the private link resource.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return REST model used to encapsulate Private Link properties for tracked resources.
     */
    public suspend
    fun getPrivateEndpointConnectionController(argument: GetPrivateEndpointConnectionControllerPlainArgs):
        GetPrivateEndpointConnectionControllerResult =
        getPrivateEndpointConnectionControllerResultToKotlin(getPrivateEndpointConnectionControllerPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionController].
     * @param peConnectionName  Private link resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return REST model used to encapsulate Private Link properties for tracked resources.
     */
    public suspend fun getPrivateEndpointConnectionController(
        peConnectionName: String,
        resourceGroupName: String,
        siteName: String,
    ): GetPrivateEndpointConnectionControllerResult {
        val argument = GetPrivateEndpointConnectionControllerPlainArgs(
            peConnectionName = peConnectionName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getPrivateEndpointConnectionControllerResultToKotlin(getPrivateEndpointConnectionControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionControllerPlainArgs].
     * @return REST model used to encapsulate Private Link properties for tracked resources.
     */
    public suspend
    fun getPrivateEndpointConnectionController(argument: suspend GetPrivateEndpointConnectionControllerPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionControllerResult {
        val builder = GetPrivateEndpointConnectionControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionControllerResultToKotlin(getPrivateEndpointConnectionControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ServerSiteResource
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A ServerSiteResource
     */
    public suspend fun getServerSitesController(argument: GetServerSitesControllerPlainArgs):
        GetServerSitesControllerResult =
        getServerSitesControllerResultToKotlin(getServerSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getServerSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A ServerSiteResource
     */
    public suspend fun getServerSitesController(resourceGroupName: String, siteName: String):
        GetServerSitesControllerResult {
        val argument = GetServerSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getServerSitesControllerResultToKotlin(getServerSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetServerSitesControllerPlainArgs].
     * @return A ServerSiteResource
     */
    public suspend
    fun getServerSitesController(argument: suspend GetServerSitesControllerPlainArgsBuilder.() -> Unit):
        GetServerSitesControllerResult {
        val builder = GetServerSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerSitesControllerResultToKotlin(getServerSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Site REST Resource.
     * Azure REST API version: 2020-07-07.
     * @param argument null
     * @return Site REST Resource.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name.
     * @return Site REST Resource.
     */
    public suspend fun getSite(resourceGroupName: String, siteName: String): GetSiteResult {
        val argument = GetSitePlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return Site REST Resource.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a VmwareSite
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A VmwareSite
     */
    public suspend fun getSitesController(argument: GetSitesControllerPlainArgs):
        GetSitesControllerResult =
        getSitesControllerResultToKotlin(getSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return A VmwareSite
     */
    public suspend fun getSitesController(resourceGroupName: String, siteName: String):
        GetSitesControllerResult {
        val argument = GetSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getSitesControllerResultToKotlin(getSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetSitesControllerPlainArgs].
     * @return A VmwareSite
     */
    public suspend
    fun getSitesController(argument: suspend GetSitesControllerPlainArgsBuilder.() -> Unit):
        GetSitesControllerResult {
        val builder = GetSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSitesControllerResultToKotlin(getSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SqlDiscoverySiteDataSource
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A SQL discovery site data source resource.
     */
    public suspend
    fun getSqlDiscoverySiteDataSourceController(argument: GetSqlDiscoverySiteDataSourceControllerPlainArgs):
        GetSqlDiscoverySiteDataSourceControllerResult =
        getSqlDiscoverySiteDataSourceControllerResultToKotlin(getSqlDiscoverySiteDataSourceControllerPlain(argument.toJava()).await())

    /**
     * @see [getSqlDiscoverySiteDataSourceController].
     * @param discoverySiteDataSourceName SQL Discovery site data source name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @param sqlSiteName SQL site name.
     * @return A SQL discovery site data source resource.
     */
    public suspend fun getSqlDiscoverySiteDataSourceController(
        discoverySiteDataSourceName: String,
        resourceGroupName: String,
        siteName: String,
        sqlSiteName: String,
    ): GetSqlDiscoverySiteDataSourceControllerResult {
        val argument = GetSqlDiscoverySiteDataSourceControllerPlainArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            sqlSiteName = sqlSiteName,
        )
        return getSqlDiscoverySiteDataSourceControllerResultToKotlin(getSqlDiscoverySiteDataSourceControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlDiscoverySiteDataSourceController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetSqlDiscoverySiteDataSourceControllerPlainArgs].
     * @return A SQL discovery site data source resource.
     */
    public suspend
    fun getSqlDiscoverySiteDataSourceController(argument: suspend GetSqlDiscoverySiteDataSourceControllerPlainArgsBuilder.() -> Unit):
        GetSqlDiscoverySiteDataSourceControllerResult {
        val builder = GetSqlDiscoverySiteDataSourceControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlDiscoverySiteDataSourceControllerResultToKotlin(getSqlDiscoverySiteDataSourceControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get a site.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return SQL site web model.
     */
    public suspend fun getSqlSitesController(argument: GetSqlSitesControllerPlainArgs):
        GetSqlSitesControllerResult =
        getSqlSitesControllerResultToKotlin(getSqlSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getSqlSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @param sqlSiteName SQL site name.
     * @return SQL site web model.
     */
    public suspend fun getSqlSitesController(
        resourceGroupName: String,
        siteName: String,
        sqlSiteName: String,
    ): GetSqlSitesControllerResult {
        val argument = GetSqlSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            sqlSiteName = sqlSiteName,
        )
        return getSqlSitesControllerResultToKotlin(getSqlSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetSqlSitesControllerPlainArgs].
     * @return SQL site web model.
     */
    public suspend
    fun getSqlSitesController(argument: suspend GetSqlSitesControllerPlainArgsBuilder.() -> Unit):
        GetSqlSitesControllerResult {
        val builder = GetSqlSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlSitesControllerResultToKotlin(getSqlSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Vcenter
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return A vcenter resource belonging to a site resource.
     */
    public suspend fun getVcenterController(argument: GetVcenterControllerPlainArgs):
        GetVcenterControllerResult =
        getVcenterControllerResultToKotlin(getVcenterControllerPlain(argument.toJava()).await())

    /**
     * @see [getVcenterController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @param vcenterName  VCenters name
     * @return A vcenter resource belonging to a site resource.
     */
    public suspend fun getVcenterController(
        resourceGroupName: String,
        siteName: String,
        vcenterName: String,
    ): GetVcenterControllerResult {
        val argument = GetVcenterControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            vcenterName = vcenterName,
        )
        return getVcenterControllerResultToKotlin(getVcenterControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getVcenterController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetVcenterControllerPlainArgs].
     * @return A vcenter resource belonging to a site resource.
     */
    public suspend
    fun getVcenterController(argument: suspend GetVcenterControllerPlainArgsBuilder.() -> Unit):
        GetVcenterControllerResult {
        val builder = GetVcenterControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVcenterControllerResultToKotlin(getVcenterControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get a Web app data source in site.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return Web app data source web model.
     */
    public suspend
    fun getWebAppDiscoverySiteDataSourcesController(argument: GetWebAppDiscoverySiteDataSourcesControllerPlainArgs):
        GetWebAppDiscoverySiteDataSourcesControllerResult =
        getWebAppDiscoverySiteDataSourcesControllerResultToKotlin(getWebAppDiscoverySiteDataSourcesControllerPlain(argument.toJava()).await())

    /**
     * @see [getWebAppDiscoverySiteDataSourcesController].
     * @param discoverySiteDataSourceName Data Source ARM name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @param webAppSiteName Web app site name.
     * @return Web app data source web model.
     */
    public suspend fun getWebAppDiscoverySiteDataSourcesController(
        discoverySiteDataSourceName: String,
        resourceGroupName: String,
        siteName: String,
        webAppSiteName: String,
    ): GetWebAppDiscoverySiteDataSourcesControllerResult {
        val argument = GetWebAppDiscoverySiteDataSourcesControllerPlainArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            webAppSiteName = webAppSiteName,
        )
        return getWebAppDiscoverySiteDataSourcesControllerResultToKotlin(getWebAppDiscoverySiteDataSourcesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAppDiscoverySiteDataSourcesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetWebAppDiscoverySiteDataSourcesControllerPlainArgs].
     * @return Web app data source web model.
     */
    public suspend
    fun getWebAppDiscoverySiteDataSourcesController(argument: suspend GetWebAppDiscoverySiteDataSourcesControllerPlainArgsBuilder.() -> Unit):
        GetWebAppDiscoverySiteDataSourcesControllerResult {
        val builder = GetWebAppDiscoverySiteDataSourcesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAppDiscoverySiteDataSourcesControllerResultToKotlin(getWebAppDiscoverySiteDataSourcesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get a site.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return WebApp site web model.
     */
    public suspend fun getWebAppSitesController(argument: GetWebAppSitesControllerPlainArgs):
        GetWebAppSitesControllerResult =
        getWebAppSitesControllerResultToKotlin(getWebAppSitesControllerPlain(argument.toJava()).await())

    /**
     * @see [getWebAppSitesController].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @param webAppSiteName Web app site name.
     * @return WebApp site web model.
     */
    public suspend fun getWebAppSitesController(
        resourceGroupName: String,
        siteName: String,
        webAppSiteName: String,
    ): GetWebAppSitesControllerResult {
        val argument = GetWebAppSitesControllerPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            webAppSiteName = webAppSiteName,
        )
        return getWebAppSitesControllerResultToKotlin(getWebAppSitesControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAppSitesController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;GetWebAppSitesControllerPlainArgs].
     * @return WebApp site web model.
     */
    public suspend
    fun getWebAppSitesController(argument: suspend GetWebAppSitesControllerPlainArgsBuilder.() -> Unit):
        GetWebAppSitesControllerResult {
        val builder = GetWebAppSitesControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAppSitesControllerResultToKotlin(getWebAppSitesControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get site health summary.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listHypervSitesControllerHealthSummary(argument: ListHypervSitesControllerHealthSummaryPlainArgs):
        ListHypervSitesControllerHealthSummaryResult =
        listHypervSitesControllerHealthSummaryResultToKotlin(listHypervSitesControllerHealthSummaryPlain(argument.toJava()).await())

    /**
     * @see [listHypervSitesControllerHealthSummary].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return Collection of SiteHealthSummary.
     */
    public suspend fun listHypervSitesControllerHealthSummary(
        resourceGroupName: String,
        siteName: String,
    ): ListHypervSitesControllerHealthSummaryResult {
        val argument = ListHypervSitesControllerHealthSummaryPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return listHypervSitesControllerHealthSummaryResultToKotlin(listHypervSitesControllerHealthSummaryPlain(argument.toJava()).await())
    }

    /**
     * @see [listHypervSitesControllerHealthSummary].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;ListHypervSitesControllerHealthSummaryPlainArgs].
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listHypervSitesControllerHealthSummary(argument: suspend ListHypervSitesControllerHealthSummaryPlainArgsBuilder.() -> Unit):
        ListHypervSitesControllerHealthSummaryResult {
        val builder = ListHypervSitesControllerHealthSummaryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listHypervSitesControllerHealthSummaryResultToKotlin(listHypervSitesControllerHealthSummaryPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get site health summary.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listServerSitesControllerHealthSummary(argument: ListServerSitesControllerHealthSummaryPlainArgs):
        ListServerSitesControllerHealthSummaryResult =
        listServerSitesControllerHealthSummaryResultToKotlin(listServerSitesControllerHealthSummaryPlain(argument.toJava()).await())

    /**
     * @see [listServerSitesControllerHealthSummary].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return Collection of SiteHealthSummary.
     */
    public suspend fun listServerSitesControllerHealthSummary(
        resourceGroupName: String,
        siteName: String,
    ): ListServerSitesControllerHealthSummaryResult {
        val argument = ListServerSitesControllerHealthSummaryPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return listServerSitesControllerHealthSummaryResultToKotlin(listServerSitesControllerHealthSummaryPlain(argument.toJava()).await())
    }

    /**
     * @see [listServerSitesControllerHealthSummary].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;ListServerSitesControllerHealthSummaryPlainArgs].
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listServerSitesControllerHealthSummary(argument: suspend ListServerSitesControllerHealthSummaryPlainArgsBuilder.() -> Unit):
        ListServerSitesControllerHealthSummaryResult {
        val builder = ListServerSitesControllerHealthSummaryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServerSitesControllerHealthSummaryResultToKotlin(listServerSitesControllerHealthSummaryPlain(builtArgument.toJava()).await())
    }

    /**
     * Method to get site health summary.
     * Azure REST API version: 2023-06-06.
     * @param argument null
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listSitesControllerHealthSummary(argument: ListSitesControllerHealthSummaryPlainArgs):
        ListSitesControllerHealthSummaryResult =
        listSitesControllerHealthSummaryResultToKotlin(listSitesControllerHealthSummaryPlain(argument.toJava()).await())

    /**
     * @see [listSitesControllerHealthSummary].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName Site name
     * @return Collection of SiteHealthSummary.
     */
    public suspend fun listSitesControllerHealthSummary(resourceGroupName: String, siteName: String):
        ListSitesControllerHealthSummaryResult {
        val argument = ListSitesControllerHealthSummaryPlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return listSitesControllerHealthSummaryResultToKotlin(listSitesControllerHealthSummaryPlain(argument.toJava()).await())
    }

    /**
     * @see [listSitesControllerHealthSummary].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;offazure&#46;kotlin&#46;inputs&#46;ListSitesControllerHealthSummaryPlainArgs].
     * @return Collection of SiteHealthSummary.
     */
    public suspend
    fun listSitesControllerHealthSummary(argument: suspend ListSitesControllerHealthSummaryPlainArgsBuilder.() -> Unit):
        ListSitesControllerHealthSummaryResult {
        val builder = ListSitesControllerHealthSummaryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSitesControllerHealthSummaryResultToKotlin(listSitesControllerHealthSummaryPlain(builtArgument.toJava()).await())
    }
}
