@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * REST model used to encapsulate the user visible state of a PrivateEndpoint.
 * Azure REST API version: 2020-07-07. Prior API version in Azure Native 1.x: 2020-07-07.
 * ## Example Usage
 * ### Put privateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.OffAzure.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PeConnectionName = "privateendpt1938mastersit9007pe.4f2f2970-0bfa-45d4-9ee1-d9f79502fc6f",
 *         ResourceGroupName = "ayagrawrg",
 *         SiteName = "privateendpt1938mastersite",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &offazure.PrivateEndpointConnectionArgs{
 * 			PeConnectionName:  pulumi.String("privateendpt1938mastersit9007pe.4f2f2970-0bfa-45d4-9ee1-d9f79502fc6f"),
 * 			ResourceGroupName: pulumi.String("ayagrawrg"),
 * 			SiteName:          pulumi.String("privateendpt1938mastersite"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnection;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .peConnectionName("privateendpt1938mastersit9007pe.4f2f2970-0bfa-45d4-9ee1-d9f79502fc6f")
 *             .resourceGroupName("ayagrawrg")
 *             .siteName("privateendpt1938mastersite")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:PrivateEndpointConnection privateendpt1938mastersit9007pe.4f2f2970-0bfa-45d4-9ee1-d9f79502fc6f /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/privateEndpointConnections/{peConnectionName}
 * ```
 * @property peConnectionName Private link resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name.
 */
public data class PrivateEndpointConnectionArgs(
    public val peConnectionName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.offazure.PrivateEndpointConnectionArgs.builder()
            .peConnectionName(peConnectionName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var peConnectionName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    /**
     * @param value Private link resource name.
     */
    @JvmName("iqkxrcnbqerievwy")
    public suspend fun peConnectionName(`value`: Output<String>) {
        this.peConnectionName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ansqaxylpbblayks")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("kdpecsshoqifsthy")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Private link resource name.
     */
    @JvmName("donlvgphxscjflmf")
    public suspend fun peConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xhxxlnbtpcivxtdl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("mthgaonyqxgbypwm")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        peConnectionName = peConnectionName,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
    )
}
