@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.ResourceIdResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.ResourceIdResponse.Companion.toKotlin as resourceIdResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionController].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionControllerArgs =
        PrivateEndpointConnectionControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PrivateEndpointConnectionControllerArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.PrivateEndpointConnectionController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionController(builtJavaResource)
    }
}

/**
 * REST model used to encapsulate Private Link properties for tracked resources.
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### PrivateEndpointConnectionController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionController = new AzureNative.OffAzure.PrivateEndpointConnectionController("privateEndpointConnectionController", new()
 *     {
 *         PeConnectionName = "-KF3-86-D3L-8M",
 *         PrivateLinkServiceConnectionState = new AzureNative.OffAzure.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "swxghzuajrasojk",
 *             Description = "ljdykrrhmzi",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "LuBO2I1-B85pJ1BZ251",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewPrivateEndpointConnectionController(ctx, "privateEndpointConnectionController", &offazure.PrivateEndpointConnectionControllerArgs{
 * 			PeConnectionName: pulumi.String("-KF3-86-D3L-8M"),
 * 			PrivateLinkServiceConnectionState: &offazure.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("swxghzuajrasojk"),
 * 				Description:     pulumi.String("ljdykrrhmzi"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("LuBO2I1-B85pJ1BZ251"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionController;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionController = new PrivateEndpointConnectionController("privateEndpointConnectionController", PrivateEndpointConnectionControllerArgs.builder()
 *             .peConnectionName("-KF3-86-D3L-8M")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "swxghzuajrasojk"),
 *                 Map.entry("description", "ljdykrrhmzi"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rgmigrate")
 *             .siteName("LuBO2I1-B85pJ1BZ251")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateEndpointConnectionController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionController = new AzureNative.OffAzure.PrivateEndpointConnectionController("privateEndpointConnectionController", new()
 *     {
 *         PeConnectionName = "-p-U2",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "1--tOY-47Q-X95WC3d-U",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewPrivateEndpointConnectionController(ctx, "privateEndpointConnectionController", &offazure.PrivateEndpointConnectionControllerArgs{
 * 			PeConnectionName:  pulumi.String("-p-U2"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("1--tOY-47Q-X95WC3d-U"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionController;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionController = new PrivateEndpointConnectionController("privateEndpointConnectionController", PrivateEndpointConnectionControllerArgs.builder()
 *             .peConnectionName("-p-U2")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("1--tOY-47Q-X95WC3d-U")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:PrivateEndpointConnectionController lpmzrxdxhivwalyhlkjtl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/privateEndpointConnections/{peConnectionName}
 * ```
 */
public class PrivateEndpointConnectionController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.PrivateEndpointConnectionController,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionControllerMapper) {
    /**
     * array of group ids
     */
    public val groupIds: Output<List<String>>
        get() = javaResource.groupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * private endpoints
     */
    public val privateEndpoint: Output<ResourceIdResponse>
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceIdResponseToKotlin(args0)
            })
        })

    /**
     * private endpoints connection state
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionControllerMapper :
    ResourceMapper<PrivateEndpointConnectionController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.PrivateEndpointConnectionController::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionController =
        PrivateEndpointConnectionController(
            javaResource as
                com.pulumi.azurenative.offazure.PrivateEndpointConnectionController,
        )
}

/**
 * @see [PrivateEndpointConnectionController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionController].
 */
public suspend fun privateEndpointConnectionController(
    name: String,
    block: suspend PrivateEndpointConnectionControllerResourceBuilder.() -> Unit,
):
    PrivateEndpointConnectionController {
    val builder = PrivateEndpointConnectionControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionController(name: String): PrivateEndpointConnectionController {
    val builder = PrivateEndpointConnectionControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
