@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin as siteAgentPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin as siteSpnPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServerSitesController].
 */
@PulumiTagMarker
public class ServerSitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerSitesControllerArgs = ServerSitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerSitesControllerArgsBuilder.() -> Unit) {
        val builder = ServerSitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerSitesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.ServerSitesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerSitesController(builtJavaResource)
    }
}

/**
 * A ServerSiteResource
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### ServerSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverSitesController = new AzureNative.OffAzure.ServerSitesController("serverSitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "zkzibwptff",
 *         DiscoverySolutionId = "lvskpghpphpfumbzxroakznqplomiy",
 *         Location = "iipybgplhzhpcfv",
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "XD1X78SG23",
 *         Tags =
 *         {
 *             { "key4244", "yryvgpkoefkjkhlcahntgfz" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewServerSitesController(ctx, "serverSitesController", &offazure.ServerSitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("zkzibwptff"),
 * 			DiscoverySolutionId: pulumi.String("lvskpghpphpfumbzxroakznqplomiy"),
 * 			Location:            pulumi.String("iipybgplhzhpcfv"),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("XD1X78SG23"),
 * 			Tags: pulumi.StringMap{
 * 				"key4244": pulumi.String("yryvgpkoefkjkhlcahntgfz"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ServerSitesController;
 * import com.pulumi.azurenative.offazure.ServerSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverSitesController = new ServerSitesController("serverSitesController", ServerSitesControllerArgs.builder()
 *             .agentDetails(Map.ofEntries(
 *                 Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                 Map.entry("keyVaultUri", "qizphgqwage")
 *             ))
 *             .applianceName("zkzibwptff")
 *             .discoverySolutionId("lvskpghpphpfumbzxroakznqplomiy")
 *             .location("iipybgplhzhpcfv")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(Map.ofEntries(
 *                 Map.entry("aadAuthority", "yanzipdww"),
 *                 Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                 Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                 Map.entry("objectId", "tqrjngpgxnnto"),
 *                 Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                 Map.entry("tenantId", "vesmyhu")
 *             ))
 *             .siteName("XD1X78SG23")
 *             .tags(Map.of("key4244", "yryvgpkoefkjkhlcahntgfz"))
 *             .build());
 *     }
 * }
 * ```
 * ### ServerSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverSitesController = new AzureNative.OffAzure.ServerSitesController("serverSitesController", new()
 *     {
 *         Location = "iipybgplhzhpcfv",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "74-35-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewServerSitesController(ctx, "serverSitesController", &offazure.ServerSitesControllerArgs{
 * 			Location:          pulumi.String("iipybgplhzhpcfv"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("74-35-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ServerSitesController;
 * import com.pulumi.azurenative.offazure.ServerSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverSitesController = new ServerSitesController("serverSitesController", ServerSitesControllerArgs.builder()
 *             .location("iipybgplhzhpcfv")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("74-35-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:ServerSitesController eslhfxcnkskfrjdblkkko /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/serverSites/{siteName}
 * ```
 */
public class ServerSitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.ServerSitesController,
) : KotlinCustomResource(javaResource, ServerSitesControllerMapper) {
    /**
     * Gets or sets the on-premises agent details.
     */
    public val agentDetails: Output<SiteAgentPropertiesResponse>?
        get() = javaResource.agentDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    siteAgentPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the Appliance Name.
     */
    public val applianceName: Output<String>?
        get() = javaResource.applianceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the ARM ID of migration hub solution for SDS.
     */
    public val discoverySolutionId: Output<String>?
        get() = javaResource.discoverySolutionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets the Master Site this site is linked to.
     */
    public val masterSiteId: Output<String>
        get() = javaResource.masterSiteId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the service endpoint.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesResponse>?
        get() = javaResource.servicePrincipalIdentityDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> siteSpnPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerSitesControllerMapper : ResourceMapper<ServerSitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.ServerSitesController::class == javaResource::class

    override fun map(javaResource: Resource): ServerSitesController =
        ServerSitesController(javaResource as com.pulumi.azurenative.offazure.ServerSitesController)
}

/**
 * @see [ServerSitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerSitesController].
 */
public suspend fun serverSitesController(
    name: String,
    block: suspend ServerSitesControllerResourceBuilder.() -> Unit,
): ServerSitesController {
    val builder = ServerSitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerSitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverSitesController(name: String): ServerSitesController {
    val builder = ServerSitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
