@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin as siteAgentPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin as siteSpnPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SitesController].
 */
@PulumiTagMarker
public class SitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SitesControllerArgs = SitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SitesControllerArgsBuilder.() -> Unit) {
        val builder = SitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SitesController {
        val builtJavaResource = com.pulumi.azurenative.offazure.SitesController(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SitesController(builtJavaResource)
    }
}

/**
 * A VmwareSite
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### SitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sitesController = new AzureNative.OffAzure.SitesController("sitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "zkzibwptff",
 *         DiscoverySolutionId = "lvskpghpphpfumbzxroakznqplomiy",
 *         Location = "mh",
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "3-MmUUL6025",
 *         Tags =
 *         {
 *             { "key7046", "qywdefracwwzlugbwgqbt" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSitesController(ctx, "sitesController", &offazure.SitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("zkzibwptff"),
 * 			DiscoverySolutionId: pulumi.String("lvskpghpphpfumbzxroakznqplomiy"),
 * 			Location:            pulumi.String("mh"),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("3-MmUUL6025"),
 * 			Tags: pulumi.StringMap{
 * 				"key7046": pulumi.String("qywdefracwwzlugbwgqbt"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SitesController;
 * import com.pulumi.azurenative.offazure.SitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sitesController = new SitesController("sitesController", SitesControllerArgs.builder()
 *             .agentDetails(Map.ofEntries(
 *                 Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                 Map.entry("keyVaultUri", "qizphgqwage")
 *             ))
 *             .applianceName("zkzibwptff")
 *             .discoverySolutionId("lvskpghpphpfumbzxroakznqplomiy")
 *             .location("mh")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(Map.ofEntries(
 *                 Map.entry("aadAuthority", "yanzipdww"),
 *                 Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                 Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                 Map.entry("objectId", "tqrjngpgxnnto"),
 *                 Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                 Map.entry("tenantId", "vesmyhu")
 *             ))
 *             .siteName("3-MmUUL6025")
 *             .tags(Map.of("key7046", "qywdefracwwzlugbwgqbt"))
 *             .build());
 *     }
 * }
 * ```
 * ### SitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sitesController = new AzureNative.OffAzure.SitesController("sitesController", new()
 *     {
 *         Location = "mh",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "KPV1Y68-G0V",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSitesController(ctx, "sitesController", &offazure.SitesControllerArgs{
 * 			Location:          pulumi.String("mh"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("KPV1Y68-G0V"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SitesController;
 * import com.pulumi.azurenative.offazure.SitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sitesController = new SitesController("sitesController", SitesControllerArgs.builder()
 *             .location("mh")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("KPV1Y68-G0V")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SitesController zdlnpiprfzpnvyoysx /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/vmwareSites/{siteName}
 * ```
 */
public class SitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.SitesController,
) : KotlinCustomResource(javaResource, SitesControllerMapper) {
    /**
     * Gets or sets the on-premises agent details.
     */
    public val agentDetails: Output<SiteAgentPropertiesResponse>?
        get() = javaResource.agentDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    siteAgentPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the Appliance Name.
     */
    public val applianceName: Output<String>?
        get() = javaResource.applianceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the ARM ID of migration hub solution for SDS.
     */
    public val discoverySolutionId: Output<String>?
        get() = javaResource.discoverySolutionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets the Master Site this site is linked to.
     */
    public val masterSiteId: Output<String>
        get() = javaResource.masterSiteId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the service endpoint.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesResponse>?
        get() = javaResource.servicePrincipalIdentityDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> siteSpnPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SitesControllerMapper : ResourceMapper<SitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.SitesController::class == javaResource::class

    override fun map(javaResource: Resource): SitesController = SitesController(
        javaResource as
            com.pulumi.azurenative.offazure.SitesController,
    )
}

/**
 * @see [SitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SitesController].
 */
public suspend fun sitesController(
    name: String,
    block: suspend SitesControllerResourceBuilder.() -> Unit,
): SitesController {
    val builder = SitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sitesController(name: String): SitesController {
    val builder = SitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
