@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.SitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A VmwareSite
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### SitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sitesController = new AzureNative.OffAzure.SitesController("sitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "zkzibwptff",
 *         DiscoverySolutionId = "lvskpghpphpfumbzxroakznqplomiy",
 *         Location = "mh",
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "3-MmUUL6025",
 *         Tags =
 *         {
 *             { "key7046", "qywdefracwwzlugbwgqbt" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSitesController(ctx, "sitesController", &offazure.SitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("zkzibwptff"),
 * 			DiscoverySolutionId: pulumi.String("lvskpghpphpfumbzxroakznqplomiy"),
 * 			Location:            pulumi.String("mh"),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("3-MmUUL6025"),
 * 			Tags: pulumi.StringMap{
 * 				"key7046": pulumi.String("qywdefracwwzlugbwgqbt"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SitesController;
 * import com.pulumi.azurenative.offazure.SitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sitesController = new SitesController("sitesController", SitesControllerArgs.builder()
 *             .agentDetails(Map.ofEntries(
 *                 Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                 Map.entry("keyVaultUri", "qizphgqwage")
 *             ))
 *             .applianceName("zkzibwptff")
 *             .discoverySolutionId("lvskpghpphpfumbzxroakznqplomiy")
 *             .location("mh")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(Map.ofEntries(
 *                 Map.entry("aadAuthority", "yanzipdww"),
 *                 Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                 Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                 Map.entry("objectId", "tqrjngpgxnnto"),
 *                 Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                 Map.entry("tenantId", "vesmyhu")
 *             ))
 *             .siteName("3-MmUUL6025")
 *             .tags(Map.of("key7046", "qywdefracwwzlugbwgqbt"))
 *             .build());
 *     }
 * }
 * ```
 * ### SitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sitesController = new AzureNative.OffAzure.SitesController("sitesController", new()
 *     {
 *         Location = "mh",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "KPV1Y68-G0V",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSitesController(ctx, "sitesController", &offazure.SitesControllerArgs{
 * 			Location:          pulumi.String("mh"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("KPV1Y68-G0V"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SitesController;
 * import com.pulumi.azurenative.offazure.SitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sitesController = new SitesController("sitesController", SitesControllerArgs.builder()
 *             .location("mh")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("KPV1Y68-G0V")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SitesController zdlnpiprfzpnvyoysx /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/vmwareSites/{siteName}
 * ```
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property servicePrincipalIdentityDetails Gets or sets the service principal identity details used by agent for
 * communication
 *             to the service.
 * @property siteName Site name
 * @property tags Resource tags.
 */
public data class SitesControllerArgs(
    public val agentDetails: Output<SiteAgentPropertiesArgs>? = null,
    public val applianceName: Output<String>? = null,
    public val discoverySolutionId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.SitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.SitesControllerArgs =
        com.pulumi.azurenative.offazure.SitesControllerArgs.builder()
            .agentDetails(agentDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .applianceName(applianceName?.applyValue({ args0 -> args0 }))
            .discoverySolutionId(discoverySolutionId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePrincipalIdentityDetails(
                servicePrincipalIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SitesControllerArgs].
 */
@PulumiTagMarker
public class SitesControllerArgsBuilder internal constructor() {
    private var agentDetails: Output<SiteAgentPropertiesArgs>? = null

    private var applianceName: Output<String>? = null

    private var discoverySolutionId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("dkscnhvlupegyvji")
    public suspend fun agentDetails(`value`: Output<SiteAgentPropertiesArgs>) {
        this.agentDetails = value
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("vsisllfospwhnglq")
    public suspend fun applianceName(`value`: Output<String>) {
        this.applianceName = value
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("agggtdjtasycicxx")
    public suspend fun discoverySolutionId(`value`: Output<String>) {
        this.discoverySolutionId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fkhojxsafaufdfrn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mlxboxuepbutaiyp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("fmvrjuktkjcndkvm")
    public suspend fun servicePrincipalIdentityDetails(`value`: Output<SiteSpnPropertiesArgs>) {
        this.servicePrincipalIdentityDetails = value
    }

    /**
     * @param value Site name
     */
    @JvmName("wtyeniletxoilbgh")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pojtudvaivywkyii")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("emsivhtxexdudkcq")
    public suspend fun agentDetails(`value`: SiteAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentDetails = mapped
    }

    /**
     * @param argument Gets or sets the on-premises agent details.
     */
    @JvmName("qsgqlbbryvlqjpjj")
    public suspend fun agentDetails(argument: suspend SiteAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentDetails = mapped
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("bnkibpwylmwxbvxa")
    public suspend fun applianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceName = mapped
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("mthiwjxmmehquudg")
    public suspend fun discoverySolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySolutionId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rjtgjxowwweesxtl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("piwniooccbncpfbv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("faeyhabwihumsyvs")
    public suspend fun servicePrincipalIdentityDetails(`value`: SiteSpnPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param argument Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("unwqnpygyrxscayo")
    public suspend
    fun servicePrincipalIdentityDetails(argument: suspend SiteSpnPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteSpnPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("stwbbbsqtvwkodvy")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tdexpcitunppqrvj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qwiuqbisfdamcsfs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SitesControllerArgs = SitesControllerArgs(
        agentDetails = agentDetails,
        applianceName = applianceName,
        discoverySolutionId = discoverySolutionId,
        location = location,
        resourceGroupName = resourceGroupName,
        servicePrincipalIdentityDetails = servicePrincipalIdentityDetails,
        siteName = siteName,
        tags = tags,
    )
}
