@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.VcenterControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A vcenter resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### VcenterController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vcenterController = new AzureNative.OffAzure.VcenterController("vcenterController", new()
 *     {
 *         Fqdn = "mzrejobgzhpxhynsfpumuhk",
 *         FriendlyName = "qqsnhutpvockzhwuesuohnfirvxmw",
 *         Port = "ahagklwzutlumcdhawkrfzmpfypcz",
 *         ProvisioningState = "Created",
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "orrfsvlcuoagqlkkqsd",
 *         SiteName = "Snu-38v6",
 *         VcenterName = "e72lZRSD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewVcenterController(ctx, "vcenterController", &offazure.VcenterControllerArgs{
 * 			Fqdn:              pulumi.String("mzrejobgzhpxhynsfpumuhk"),
 * 			FriendlyName:      pulumi.String("qqsnhutpvockzhwuesuohnfirvxmw"),
 * 			Port:              pulumi.String("ahagklwzutlumcdhawkrfzmpfypcz"),
 * 			ProvisioningState: pulumi.String("Created"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("orrfsvlcuoagqlkkqsd"),
 * 			SiteName:          pulumi.String("Snu-38v6"),
 * 			VcenterName:       pulumi.String("e72lZRSD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.VcenterController;
 * import com.pulumi.azurenative.offazure.VcenterControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vcenterController = new VcenterController("vcenterController", VcenterControllerArgs.builder()
 *             .fqdn("mzrejobgzhpxhynsfpumuhk")
 *             .friendlyName("qqsnhutpvockzhwuesuohnfirvxmw")
 *             .port("ahagklwzutlumcdhawkrfzmpfypcz")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("orrfsvlcuoagqlkkqsd")
 *             .siteName("Snu-38v6")
 *             .vcenterName("e72lZRSD")
 *             .build());
 *     }
 * }
 * ```
 * ### VcenterController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vcenterController = new AzureNative.OffAzure.VcenterController("vcenterController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "6-qSc554IYc4U08",
 *         VcenterName = "R5I8Xj8--zsS6JYI-0FNhe",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewVcenterController(ctx, "vcenterController", &offazure.VcenterControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("6-qSc554IYc4U08"),
 * 			VcenterName:       pulumi.String("R5I8Xj8--zsS6JYI-0FNhe"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.VcenterController;
 * import com.pulumi.azurenative.offazure.VcenterControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vcenterController = new VcenterController("vcenterController", VcenterControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("6-qSc554IYc4U08")
 *             .vcenterName("R5I8Xj8--zsS6JYI-0FNhe")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:VcenterController vznkdfjpbb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/vmwareSites/{siteName}/vcenters/{vcenterName}
 * ```
 * @property fqdn Gets or sets the FQDN/IPAddress of the vCenter.
 * @property friendlyName Gets or sets the friendly name of the vCenter.
 * @property port Gets or sets the port of the vCenter.
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property runAsAccountId Gets or sets the run as account ID of the vCenter.
 * @property siteName Site name
 * @property vcenterName  VCenters name
 */
public data class VcenterControllerArgs(
    public val fqdn: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val port: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val vcenterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.VcenterControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.VcenterControllerArgs =
        com.pulumi.azurenative.offazure.VcenterControllerArgs.builder()
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .vcenterName(vcenterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VcenterControllerArgs].
 */
@PulumiTagMarker
public class VcenterControllerArgsBuilder internal constructor() {
    private var fqdn: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var port: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var siteName: Output<String>? = null

    private var vcenterName: Output<String>? = null

    /**
     * @param value Gets or sets the FQDN/IPAddress of the vCenter.
     */
    @JvmName("lxieolrriljktudn")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Gets or sets the friendly name of the vCenter.
     */
    @JvmName("bycvakfgcjkqmdoq")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Gets or sets the port of the vCenter.
     */
    @JvmName("sgbrmkktulymqrtd")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("tconxdwphjxcbjnm")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jxnxajlijuvfrhjx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the run as account ID of the vCenter.
     */
    @JvmName("pabwwnacjkucbrqo")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value Site name
     */
    @JvmName("bpxpwdgthpiadblq")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value  VCenters name
     */
    @JvmName("xhikcgfetmlabkkt")
    public suspend fun vcenterName(`value`: Output<String>) {
        this.vcenterName = value
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the vCenter.
     */
    @JvmName("yigatbgqywluyamw")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Gets or sets the friendly name of the vCenter.
     */
    @JvmName("mstdesujktpkpfeg")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Gets or sets the port of the vCenter.
     */
    @JvmName("xemiwmymvnoykynq")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("nfnorypjjbiaqiam")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ciqwooeorfpyxcsk")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("luvcnfntewigdssa")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnyfrsnebifsogsw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the run as account ID of the vCenter.
     */
    @JvmName("lbaknltfnqilfwmb")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("afdykuymsnrcywxh")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value  VCenters name
     */
    @JvmName("mluhmsewuspmrkss")
    public suspend fun vcenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcenterName = mapped
    }

    internal fun build(): VcenterControllerArgs = VcenterControllerArgs(
        fqdn = fqdn,
        friendlyName = friendlyName,
        port = port,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        runAsAccountId = runAsAccountId,
        siteName = siteName,
        vcenterName = vcenterName,
    )
}
