@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Web app data source web model.
 * Azure REST API version: 2023-06-06.
 * ## Example Usage
 * ### WebAppDiscoverySiteDataSourcesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppDiscoverySiteDataSourcesController = new AzureNative.OffAzure.WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", new()
 *     {
 *         DiscoverySiteDataSourceName = "171iiIY1M39-M--VU2x8uOy",
 *         DiscoverySiteId = "fwkwva",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "0M4C6JZc",
 *         WebAppSiteName = "QhlGHU7obm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppDiscoverySiteDataSourcesController(ctx, "webAppDiscoverySiteDataSourcesController", &offazure.WebAppDiscoverySiteDataSourcesControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("171iiIY1M39-M--VU2x8uOy"),
 * 			DiscoverySiteId:             pulumi.String("fwkwva"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("0M4C6JZc"),
 * 			WebAppSiteName:              pulumi.String("QhlGHU7obm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppDiscoverySiteDataSourcesController = new WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", WebAppDiscoverySiteDataSourcesControllerArgs.builder()
 *             .discoverySiteDataSourceName("171iiIY1M39-M--VU2x8uOy")
 *             .discoverySiteId("fwkwva")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("0M4C6JZc")
 *             .webAppSiteName("QhlGHU7obm")
 *             .build());
 *     }
 * }
 * ```
 * ### WebAppDiscoverySiteDataSourcesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppDiscoverySiteDataSourcesController = new AzureNative.OffAzure.WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", new()
 *     {
 *         DiscoverySiteDataSourceName = "Q-38555Y-2-8-6-bdZk2y",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "257-4BP-1j",
 *         WebAppSiteName = "S--3265vli3j4X--Vy-J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppDiscoverySiteDataSourcesController(ctx, "webAppDiscoverySiteDataSourcesController", &offazure.WebAppDiscoverySiteDataSourcesControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("Q-38555Y-2-8-6-bdZk2y"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("257-4BP-1j"),
 * 			WebAppSiteName:              pulumi.String("S--3265vli3j4X--Vy-J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppDiscoverySiteDataSourcesController = new WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", WebAppDiscoverySiteDataSourcesControllerArgs.builder()
 *             .discoverySiteDataSourceName("Q-38555Y-2-8-6-bdZk2y")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("257-4BP-1j")
 *             .webAppSiteName("S--3265vli3j4X--Vy-J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:WebAppDiscoverySiteDataSourcesController torp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/webAppSites/{webAppSiteName}/discoverySiteDataSources/{discoverySiteDataSourceName}
 * ```
 * @property discoverySiteDataSourceName Data Source ARM name.
 * @property discoverySiteId Gets or sets the discovery site Id.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property webAppSiteName Web app site name.
 */
public data class WebAppDiscoverySiteDataSourcesControllerArgs(
    public val discoverySiteDataSourceName: Output<String>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val webAppSiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs =
        com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs.builder()
            .discoverySiteDataSourceName(discoverySiteDataSourceName?.applyValue({ args0 -> args0 }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .webAppSiteName(webAppSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppDiscoverySiteDataSourcesControllerArgs].
 */
@PulumiTagMarker
public class WebAppDiscoverySiteDataSourcesControllerArgsBuilder internal constructor() {
    private var discoverySiteDataSourceName: Output<String>? = null

    private var discoverySiteId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var webAppSiteName: Output<String>? = null

    /**
     * @param value Data Source ARM name.
     */
    @JvmName("fdmayqfddwbnjavy")
    public suspend fun discoverySiteDataSourceName(`value`: Output<String>) {
        this.discoverySiteDataSourceName = value
    }

    /**
     * @param value Gets or sets the discovery site Id.
     */
    @JvmName("ynvuyimmuexqpclv")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eyocnawmivwckeio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name
     */
    @JvmName("jbnxraytrbeineew")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Web app site name.
     */
    @JvmName("lpqcyyflmwwwswaa")
    public suspend fun webAppSiteName(`value`: Output<String>) {
        this.webAppSiteName = value
    }

    /**
     * @param value Data Source ARM name.
     */
    @JvmName("trxwqrksghgyfbnv")
    public suspend fun discoverySiteDataSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteDataSourceName = mapped
    }

    /**
     * @param value Gets or sets the discovery site Id.
     */
    @JvmName("gfllijwultmskxqu")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vegpuvvcubtfnchs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("koxfmuvvjuwcdlhb")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Web app site name.
     */
    @JvmName("gufmckespvpbrfbr")
    public suspend fun webAppSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppSiteName = mapped
    }

    internal fun build(): WebAppDiscoverySiteDataSourcesControllerArgs =
        WebAppDiscoverySiteDataSourcesControllerArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName,
            discoverySiteId = discoverySiteId,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            webAppSiteName = webAppSiteName,
        )
}
