@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetHyperVSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name.
 */
public data class GetHyperVSitePlainArgs(
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetHyperVSitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.GetHyperVSitePlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetHyperVSitePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHyperVSitePlainArgs].
 */
@PulumiTagMarker
public class GetHyperVSitePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxultwmlpcxlecyt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("levhmhhtlndvmgtt")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetHyperVSitePlainArgs = GetHyperVSitePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
    )
}
