@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetHypervHostControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName  Host name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 */
public data class GetHypervHostControllerPlainArgs(
    public val hostName: String,
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetHypervHostControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.GetHypervHostControllerPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetHypervHostControllerPlainArgs.builder()
            .hostName(hostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHypervHostControllerPlainArgs].
 */
@PulumiTagMarker
public class GetHypervHostControllerPlainArgsBuilder internal constructor() {
    private var hostName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value  Host name
     */
    @JvmName("wxacssvdbnikegso")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kyrumuqtpeiqesfk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("rbxecofnetcennqk")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetHypervHostControllerPlainArgs = GetHypervHostControllerPlainArgs(
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
    )
}
